#ifndef SCAN_HEADER__H
#define SCAN_HEADER__H

#include "dataTypes.h"
#include "CommonWithDsp/processor.h"
#include "CommonWithDsp/sctStructure.h"

//The current version of the ScanHeader
#define CURRENT_SCANHEADER_VERSION 1

/**
  The data is passed from SctApi to the outside world in this (file) format
  */
struct ScanHeader {
  UINT16 version;		///<header version
  UINT16 length;		///<header length
  UINT32 runNumber;		///<run number
  UINT32 scanNumber; 		///<scan number

  char moduleName[16];	        ///<Serial number
  
  char startTime[16];		///<Start UTC time in ISO format (with no Z appended)
  char endTime[16];		///<Start UTC time in ISO format (with no Z appended)

  UINT16 scanType;	        ///<As defined in ABCDscans.h
  UINT16 npoints;		///<Number of scan points

  UINT32 size;			///<Size of data block in 16bit words - note that this is different from the logic format of the data - see the streamers
  UINT16 dataType;		///<Datatype as defined in dataTypes.h
  UINT16 width;			///<Width of data - either 0 (N/A), 16, 32bits

  ABCDModule config;            ///<Don't need to know how big it is (look at length)

  UINT32 pntPoints;             ///<Index to point data from beginning of file
  UINT32 pntEvents;             ///<Index to event data from beginning of file
  UINT32 pntErrors;             ///<Index to error data from beginning of file
  UINT32 pntData;               ///<Index to histogram data from beginning of file
};

/**
  A holder for pointers when in memory
  */
struct scan_result_ptrs {
  ScanHeader header;

  FLOAT32* points; 			///<Point values
  UINT32* nEvents;  			///<No. events
  UINT32* nErrorEvents;  		///<No. Error Events
  void* data;				///<data
};

#endif
