#ifndef SCANWRITERFACTORY_H
#define SCANWRITERFACTORY_H

//Need definitions of UNIT16 etc
#include <CommonWithDsp/processor.h>
#include <map>
#include <utility>

using namespace std;

namespace SctData {
	
	class ScanResultWriter;
	class ScanDataWriter;
	
	class ScanWriterFactory {
	public:
		static ScanWriterFactory& getFactory();
		bool addWriterToMap(UINT16 dataType, ScanResultWriter& resultWriter, ScanDataWriter& dataWriter);
		static ScanDataWriter& getDataWriter(UINT16 dataType);
		static ScanResultWriter& getResultWriter(UINT16 dataType);
	
	private:
		ScanWriterFactory();
		map<UINT16, pair<ScanResultWriter*, ScanDataWriter*> > writerMap;
	};
	
}

#endif //#ifndef SCANWRITERFACTORY_H
