#ifndef SCANRESULTWRITER_H
#define SCANRESULTWRITER_H

#include <is/isinfo.h>
#include "scan.h"
#include <string>
#include "Sct/Streamer.h"
#include "Sct/IOManager.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

using namespace std;
using namespace Sct;

namespace SctData {

/**
   A Streamer for writing ScanResults from ROD memory chunks.
   If you link to libScanResultWriter.so, you should not link to libSctData.so,
   since both provide streamers for SctData objects.
*/
class ScanResultWriter : public virtual Streamer {
public:
    /**
    For truely public access
    @throws IoException if something bad happens whilst writing
    @throws LogicError if you give it something it doesn't know how to deal with
    */
    static bool publish(scan_result_ptrs& scanResult);

    /**
    Not for truely public access - some other mechanism maybe??
    */
    static ScanResultWriter& getRawWriter();
    //static ScanResultWriter& getFitWriter();
    static void writeClass(const string& name, OStream& out);
    
    //Streamer overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    
    //Do nothing:
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);

    virtual unsigned getVersion() const throw();
protected:
    scan_result_ptrs* scanResult;		//Points to a scan_result object

    void setData(scan_result_ptrs& scanResult);
    void writeGuts(OStream& out) const ;
    void writeHeader(OStream& out) const;
    void writeScanPoints(OStream& out) const;
    void writeConfiguration(OStream& out) const;
    void writeChipConfig(OStream& out, const ABCDChip& data) const;
    void writeData(OStream& out) const;

private:
    //Constructor - all public access via static methods
    ScanResultWriter(const string& className, unsigned version);

    string className;
    unsigned m_version;
    static bool rawInMap;
};

}

#endif //#ifndef SCANRESULTWRITER_H
