/*
 * ScanPointsTest.java
 *
 * Created on 17 September 2003, 18:56
 */

package SctData;

import junit.framework.*;
import Sct.*;
import Sct.TestFramework.*;
import hep.aida.*;

/**
 *
 * @author  palmer
 */
public class ScanPointsTest extends StreamableTestCase{
    
    public Streamable getStreamable() {
        float[] pts = {0.5f, 1.f, 1.5f, 2.f, 3.f};
        int[] nEvents = {10, 20, 30, 40, 50};
        int[] nErrorEvents = {0, 1, 2, 3, 4};
        ScanPoints spts = new ScanPoints(pts, nEvents, nErrorEvents);
        return spts;
    }

    
    public void testAdd() throws java.lang.NoSuchFieldException {
        float[] pts = {0.5f, 1.f, 1.5f, 2.f};
        int[] nEvents = {10, 20, 30, 40};
        int[] nErrorEvents = {0, 1, 2, 3};
        ScanPoints spts1 = new ScanPoints(pts, nEvents, nErrorEvents);
        
        float[] pts2 = {0.5f, 1.f, 1.5f, 2.f, 3.f};
        int[] nEvents2 = {10, 20, 30, 40, 50};
        int[] nErrorEvents2 = {0, 1, 2, 3, 4};
        ScanPoints spts2 = new ScanPoints(pts2, nEvents2, nErrorEvents2);
        
        spts1.addPoint(3, 50, 4);
        assertTrue(compare(spts1, spts2));
    }
    
    public void testAxis() {
        float[] pts = {0.5f, 1.f, 1.5f, 2.f, 3.f};
        int[] nEvents = {10, 20, 30, 40, 50};
        int[] nErrorEvents = {0, 1, 2, 3, 4};
        ScanPoints spts = new ScanPoints(pts, nEvents, nErrorEvents);
        
        IAxis axis = spts.getAxis();
        assertEquals(axis.bins(), pts.length);
        assertEquals(axis.lowerEdge(), 0.25, 0.00001);
        assertEquals(axis.upperEdge(), 3.5, 0.00001);
    }
}
