/*
 * RawScanResultTest.java
 *
 * Created on 04 October 2003, 11:11
 */

package SctData;

import junit.framework.*;
import Sct.*;
import Sct.TestFramework.*;
import hep.aida.ref.histogram.*;
import hep.aida.ref.*;
import hep.aida.*;
import java.util.*;

/**
 * Also tests ScanResult methods (not that there are any!)
 * @author  palmer
 */
public class RawScanResultTest extends StreamableTestCase {
    
    public Streamable getStreamable() {
        ResultHeaderTest shTest = new ResultHeaderTest();
        ModuleConfigurationTest mcTest = new ModuleConfigurationTest();
        ScanPointsTest spTest = new ScanPointsTest();
        
        ResultHeader header = (ResultHeader)shTest.getStreamable();
        ModuleConfiguration mc = (ModuleConfiguration)mcTest.getStreamable();
        ScanPoints points = (ScanPoints)spTest.getStreamable();
        
        FixedAxis xAxis = new FixedAxis(Parameters.nChannelModule, -0.5, Parameters.nChannelModule+0.5);
        Histogram2D data = new Histogram2D("TestData", "TestData", xAxis, points.getAxis());
        simulateData(data, 10000);
        
        return new RawScanResult(header, mc, points, data);
    }

    
    /**
     * Fills data with some random stuff
     */
    void simulateData(IHistogram2D data, int nEvents) {
        Random r = new Random();
        double xLowEdge = data.xAxis().lowerEdge();
        double xHighEdge = data.xAxis().upperEdge();
        double yLowEdge = data.yAxis().lowerEdge();
        double yHighEdge = data.yAxis().upperEdge();
        
        for (int i=0; i<nEvents; ++i) {
            double x = xLowEdge + r.nextDouble() * (xHighEdge-xLowEdge);
            double y = 0.5*(yLowEdge+yHighEdge) + r.nextGaussian()*(yHighEdge-yLowEdge)/5;
            //Check we don't use the under or over flow bins
            if (x > xLowEdge && x < xHighEdge && y > yLowEdge && y < yHighEdge) {
                data.fill(x, y);
            }             
        }
        for (int i=0; i<data.xAxis().bins(); ++i) {
            if (data.binHeight(i, IAxis.OVERFLOW_BIN) > 0) {
                System.out.println(data.binHeight(i, IAxis.OVERFLOW_BIN));
            }
            if (data.binHeight(i, IAxis.UNDERFLOW_BIN) > 0) {
                System.out.println(data.binHeight(i, IAxis.UNDERFLOW_BIN));
            }
        }
    }
    
    protected boolean compare(Object o1, Object o2) throws java.lang.NoSuchFieldException {
        HashSet set = new HashSet();
        set.add(Histogram2D.class.getDeclaredField("meanX"));
        set.add(Histogram2D.class.getDeclaredField("rmsX"));        
        set.add(Histogram2D.class.getDeclaredField("meanY"));
        set.add(Histogram2D.class.getDeclaredField("rmsY"));
        
        set.add(Histogram.class.getDeclaredField("allEntries"));        
        set.add(Histogram.class.getDeclaredField("sumOfWeights"));
        set.add(Histogram.class.getDeclaredField("sumOfWeightsSquared"));
        set.add(AbstractBaseHistogram.class.getDeclaredField("annotation"));
        set.add(ManagedObject.class.getDeclaredField("name"));
        set.add(hep.aida.ref.histogram.binner.BasicBinner2D.class.getDeclaredField("entries"));
        //set.add(hep.aida.ref.histogram.binner.BasicBinner2D.class.getDeclaredField("heights"));
        set.add(hep.aida.ref.histogram.binner.BasicBinner2D.class.getDeclaredField("plusErrors"));
        //set.add(hep.aida.ref.histogram.binner.BasicBinner2D.class.getDeclaredField("minusErrors"));
        set.add(hep.aida.ref.histogram.binner.BasicBinner2D.class.getDeclaredField("meansX"));
        set.add(hep.aida.ref.histogram.binner.BasicBinner2D.class.getDeclaredField("meansY"));
        set.add(hep.aida.ref.histogram.binner.BasicBinner2D.class.getDeclaredField("rmssX"));
        set.add(hep.aida.ref.histogram.binner.BasicBinner2D.class.getDeclaredField("rmssY"));
        
        
        boolean ret = DataCompare.compare(o1, o2, set);
        if (!ret) fail(DataCompare.lastFailure.toString());
        return ret;
    }
}
