/*
 * ModuleElementTest.java
 *
 * Created on 18 September 2003, 11:28
 */

package SctData;

import Sct.*;
import junit.framework.*;
import Sct.TestFramework.*;

/**
 *
 * @author  palmer
 */
public class ModuleElementTest extends StreamableTestCase {
    
    public void testAll() {
        //Create a load of elements
        ModuleElement channel = ModuleElement.channel(200);
        ModuleElement chip = ModuleElement.chip(5);
        ModuleElement link = ModuleElement.link(1);
        ModuleElement module = ModuleElement.module();
        ModuleElement lump = new ModuleElement(400, 700);
        ModuleElement chip5 = new ModuleElement(Parameters.nChannelChip * 5, Parameters.nChannelChip * 6 - 1);
        
        //Check the data members
        assertEquals(lump.getFirst(), 400); 
        assertEquals(lump.getLast(), 700);
        assertEquals(channel.getFirst(), channel.getLast());
        assertEquals(chip.getFirst(), Parameters.nChannelChip * 5); 
        assertEquals(chip.getLast(), Parameters.nChannelChip * 6 - 1);
        assertEquals(link.getFirst(), Parameters.nChannelLink * 1); 
        assertEquals(link.getLast(), Parameters.nChannelLink * 2 - 1);
        assertEquals(module.getFirst(), 0); 
        assertEquals(module.getLast(), Parameters.nChannelModule - 1);
        
        //Check labelling operations
        
        //Channel
        assertTrue(channel.isChannel());
        assertFalse(channel.isChip());
        assertFalse(channel.isLink());
        assertFalse(channel.isModule());

        //Chip
        assertFalse(chip.isChannel());
        assertTrue(chip.isChip());
        assertFalse(chip.isLink());
        assertFalse(chip.isModule());

        //Link
        assertFalse(link.isChannel());
        assertFalse(link.isChip());
        assertTrue(link.isLink());
        assertFalse(link.isModule());
        
        //Module
        assertFalse(module.isChannel());
        assertFalse(module.isChip());
        assertFalse(module.isLink());
        assertTrue(module.isModule());
        
        //Lump
        assertFalse(lump.isChannel());
        assertFalse(lump.isChip());
        assertFalse(lump.isLink());
        assertFalse(lump.isModule());

        //Now check comparisons etc 
        
        //Check equality
        assertEquals(chip, chip5);
        
        //Check subset
        assertTrue(chip.subset(module));
        assertFalse(chip.subset(link));
        
        //Check superset
        assertTrue(module.superset(lump));
        assertFalse(channel.superset(chip));
        
        //Check overlap
        assertTrue(lump.overlaps(chip5));
        assertFalse(lump.overlaps(link));
        
    }
    
    protected boolean compare(Object s1, Object s2) {
        return s1.equals(s2);
    }
    
    public Streamable getStreamable() {
        return ModuleElement.module();
    }
    
}
