/*
 * ModuleDefectListTest.java
 *
 * Created on 18 September 2003, 17:26
 */

package SctData;

import Sct.*;
import Sct.TestFramework.*;

/**
 *
 * @author  palmer
 */
public class ModuleDefectListTest extends StreamableTestCase {

    static {
        //DataCompare.debug = true;
    }
    
    public Streamable getStreamable() {
        ModuleDefectList l = new ModuleDefectList();
        l.addDefect(new ModuleDefect(ModuleDefect.DEAD, ModuleElement.chip(10)));
        l.addDefect(new ModuleDefect(ModuleDefect.SIG_ERROR, ModuleElement.link(0)));
        l.addDefect(new ModuleDefect(ModuleDefect.FIT_OVER, ModuleElement.channel(510)));
        l.addDefect(new ModuleDefect(ModuleDefect.DEAD, ModuleElement.chip(0)));
        l.addDefect(new ModuleDefect(ModuleDefect.NOISY, ModuleElement.channel(120)));
        l.addDefect(new ModuleDefect(ModuleDefect.NOINIT, ModuleElement.channel(0)));
        l.addDefect(new ModuleDefect(ModuleDefect.PARTBONDED, ModuleElement.channel(1535)));
        l.addDefect(new ModuleDefect(ModuleDefect.FIT_OVER, new ModuleElement(10, 600)));
        l.addDefect(new ModuleDefect(ModuleDefect.NO_HI, ModuleElement.module()));
                
        return l;
    }
    
    public void testList() {
        ModuleDefectList l = (ModuleDefectList)getStreamable();
        try {
            l.addDefect(ModuleDefect.DEAD);
            fail("Should throw IllegalArgumentException");
        } catch(IllegalArgumentException e) {
        }
        assertEquals(l.getNDefectsAffectingElement(ModuleElement.channel(0)), 4);
        assertEquals(l.getNDefectsEncompassingElement(ModuleElement.chip(10)), 2);
        assertTrue(l.defectAffectingElement(ModuleElement.channel(120), ModuleDefect.NOISY));
        assertTrue(l.defectEncompassingElement(ModuleElement.chip(0)));
    }
    
}
