/*
 * ChipOptionsTest.java
 *
 * Created on 10 November 2003, 17:36
 */

package SctData;
import Sct.TestFramework.*;
import sctConf.*;

/**
 *
 * @author Matthew Palmer
 */
public class ChipOptionsTest extends StreamableTestCase {    
    
    public Sct.Streamable getStreamable() {        
        return createDirect();
    }
    
    public ChipOptions createDirect() {
        ChipOptions co = new ChipOptions(new ABCDConfig());
        co.getData().bitField = (short)0x354b;
        return co;
    }
    
    public ChipOptions createMethod() {
        ChipOptions co = new ChipOptions(new ABCDConfig());
        co.setReadOutMode((byte)3);
        co.setCalibMode((byte)2);
        co.setTrimRange((byte)0);
        co.setEdgeDetect(true);
        co.setMaskFlag(false);
        co.setAccumulate(true);
        co.setInputBypass(false);
        co.setOutputBypass(true);
        co.setMaster(false);
        co.setEnd(true);
        co.setFeedThrough(true);
        return co;
    }
    
    public void testConstruction() {
        ChipOptions co = createDirect();
        assertEquals(co.getReadOutMode(), (byte)3);
        assertEquals(co.getCalibMode(), (byte)2);
        assertEquals(co.getTrimRange(), (byte)0);
        assertEquals(co.getEdgeDetect(), true);
        assertEquals(co.getMaskFlag(), false);
        assertEquals(co.getMaskFlag(), false);
        assertEquals(co.getAccumulate(), true);
        assertEquals(co.getInputBypass(), false);
        assertEquals(co.getOutputBypass(), true);
        assertEquals(co.getMaster(), false);
        assertEquals(co.getEnd(), true);
        assertEquals(co.getFeedThrough(), true);
        assertEquals(co.getData().bitField, (short)0x354b);
    }
    
}
