/*
 * ChipConfigurationTest.java
 *
 * Created on 19 September 2003, 14:50
 */

package SctData;

import Sct.*;
import Sct.TestFramework.*;
import sctConf.*;

/**
 *
 * @author  palmer
 */
public class ChipConfigurationTest extends StreamableTestCase {
    
    
    public Streamable getStreamable() {
        ModuleConfiguration m = new ModuleConfiguration();
        ChipConfiguration c = m.getChipConfiguration(0);
        c.setActive(true);        
        c.setCalCharge((byte)230);
        c.setCalFactor(1.01f);
        c.setRcFunctionIndex((byte)2);
        c.setRcParam(1, 5.0);
        c.setStrobeDelay((byte)39);
        c.setThreshold((byte)127);
        //c.setTrimTarget((byte)85);
        //c.setTrimRange((short)3);
        c.mask(100);
        c.mask(27);
        c.setTrim(78, (byte)4);
        
        return c;
    }
    
    public void testChipConfig() {
        ChipConfiguration c = (ChipConfiguration)getStreamable();
        assertEquals(c.getTrim(78), (byte)4);
        assertTrue(c.isMasked(27));
    }
    
}
