#include "Sct/IoExceptions.h"
#include "Sct/LogicErrors.h"

#include <iostream>

using namespace std;

void f() throw(Sct::LogicError) {
    cout << "in f()...";
    throw Sct::InvalidArgumentError(" test program ", __FILE__, __LINE__);
}

void g() throw(Sct::Exception){
    cout << "in g()...";
    throw Sct::FileException(" thefilename", " test program ", __FILE__, __LINE__);
} 

int main(int argc, char** argv){
    Sct::setExceptionHandlers(argv[0]);

    cout <<"calling f() ...";
    try {
	f();
    }
    catch(Sct::LogicError &e){
	cout << "caught LogicError ... ";
	e.sendToMrs(MRS_INFORMATION);
	cout << "sent to mrs ... ";
    }

    cout << endl << "calling g()";
    try {
	g();
    }
    catch(Sct::Exception &e){
	cout << "caught Exception ...";
	e.sendToMrs(MRS_INFORMATION);
	cout << "sent to mrs ...";
    }

    cout <<"done"<<endl;
}
