#ifndef SCT_XMLSTYLESTREAM_H
#define SCT_XMLSTYLESTREAM_H
#include <sstream>
#include "OStream.h"
#include "IStream.h"

namespace Sct{
  
  class XmlStyleOStream : public OStream{
  public:
    XmlStyleOStream(std::ostream& out);
    
    virtual ~XmlStyleOStream();
    
    virtual XmlStyleOStream& operator<< ( const char * ); 
    virtual XmlStyleOStream& operator<< ( const unsigned char * ); 
    virtual XmlStyleOStream& operator<< ( bool ); 
    virtual XmlStyleOStream& operator<< ( char ); 
    virtual XmlStyleOStream& operator<< ( short ); 
    virtual XmlStyleOStream& operator<< ( int ); 
    virtual XmlStyleOStream& operator<< ( long ); 
    virtual XmlStyleOStream& operator<< ( unsigned char ); 
    virtual XmlStyleOStream& operator<< ( unsigned short ); 
    virtual XmlStyleOStream& operator<< ( unsigned int ); 
    virtual XmlStyleOStream& operator<< ( unsigned long ); 
    virtual XmlStyleOStream& operator<< ( float ); 
    virtual XmlStyleOStream& operator<< ( double );
    virtual XmlStyleOStream& operator<< ( const std::string & ); 
    
    virtual XmlStyleOStream& put( const bool * , size_t );
    virtual XmlStyleOStream& put( const char * , size_t );
    virtual XmlStyleOStream& put( const short * , size_t );
    virtual XmlStyleOStream& put( const int * , size_t );
    virtual XmlStyleOStream& put( const long * , size_t );
    virtual XmlStyleOStream& put( const unsigned char * , size_t );
    virtual XmlStyleOStream& put( const unsigned short * , size_t );
    virtual XmlStyleOStream& put( const unsigned int * , size_t );
    virtual XmlStyleOStream& put( const unsigned long * , size_t );
    virtual XmlStyleOStream& put( const float * , size_t );
    virtual XmlStyleOStream& put( const double * , size_t );
    virtual XmlStyleOStream& put( const std::string * , size_t );
    
  private:
    std::ostream& m_out;
  };

  class XmlStyleIStream : public IStream {
  public:
    XmlStyleIStream( std::istream& is );
    virtual ~XmlStyleIStream( );
    
    XmlStyleIStream& operator>> ( char *  );		
    XmlStyleIStream& operator>> ( char ** ); 
    XmlStyleIStream& operator>> ( unsigned char *  ); 
    XmlStyleIStream& operator>> ( unsigned char ** ); 
    XmlStyleIStream& operator>> ( bool &  );
    XmlStyleIStream& operator>> ( char &  );
    XmlStyleIStream& operator>> ( short &  );
    XmlStyleIStream& operator>> ( int &  );
    XmlStyleIStream& operator>> ( long &  );
    XmlStyleIStream& operator>> ( unsigned char &  );
    XmlStyleIStream& operator>> ( unsigned short &  );
    XmlStyleIStream& operator>> ( unsigned int &  );
    XmlStyleIStream& operator>> ( unsigned long &  );
    XmlStyleIStream& operator>> ( float &  );
    XmlStyleIStream& operator>> ( double &  );
    XmlStyleIStream& operator>> ( std::string &  );
    
    XmlStyleIStream& get( bool ** , size_t & );
    XmlStyleIStream& get( char ** , size_t & );
    XmlStyleIStream& get( short ** , size_t & );
    XmlStyleIStream& get( int ** , size_t & );
    XmlStyleIStream& get( long ** , size_t & );
    XmlStyleIStream& get( unsigned char ** , size_t & );
    XmlStyleIStream& get( unsigned short ** , size_t & );
    XmlStyleIStream& get( unsigned int ** , size_t & );
    XmlStyleIStream& get( unsigned long ** , size_t & );
    XmlStyleIStream& get( float ** , size_t & );
    XmlStyleIStream& get( double ** , size_t & );
    XmlStyleIStream& get( std::string ** , size_t & );
    
    XmlStyleIStream& get( bool * const , const size_t );
    XmlStyleIStream& get( char * const , const size_t );
    XmlStyleIStream& get( short * const , const size_t );
    XmlStyleIStream& get( int * const , const size_t );
    XmlStyleIStream& get( long * const , const size_t );
    XmlStyleIStream& get( unsigned char * const , const size_t );
    XmlStyleIStream& get( unsigned short * const , const size_t );
    XmlStyleIStream& get( unsigned int * const , const size_t );
    XmlStyleIStream& get( unsigned long * const , const size_t );
    XmlStyleIStream& get( float * const , const size_t );
    XmlStyleIStream& get( double * const , const size_t );
    XmlStyleIStream& get( std::string * const , const size_t );
    
  protected:
    void		reset( );
    size_t		entries( ) const;
    size_t		readSize( ) const;
    bool		isArray( ) const;
    
  private:
    std::string		data_;
    std::string::size_type	count_;
    size_t			entries_;
  };
}

#endif	// ISSTREAM_H
