#ifndef SCT_UNSUPPORTEDOPERATIONERROR_H
#define SCT_UNSUPPORTEDOPERATIONERROR_H

#include "LogicErrors.h"

namespace Sct {

/**
  Indicates a method is not supported by this class.
  @author Matthew Palmer
  @ingroup Exceptions
  */
class UnsupportedOperationError : public LogicError {
public:
    /**
      Creates an Exception with message msg and no cause
      */
    UnsupportedOperationError(const string& msg, const string& file, int line) throw() {
	initialize("NOT_SUPPORTED", "Sct::UnsupportedOperationError", msg, 0, file, line);
    }
    
    /**
      Creates an Exception with a cause.  Useful for simply wrapping
      exceptions.
      */
    UnsupportedOperationError(Throwable& cause, const string& file, int line) throw() {
	initialize("NOT_SUPPORTED", "Sct::UnsupportedOperationError", "", &cause, file, line);
    }
    
    /**
      Creates an Exception with a message and a cause
      */
    UnsupportedOperationError(const string& msg, Throwable& cause, const string& file, int line) throw() {
	initialize("NOT_SUPPORTED", "Sct::UnsupportedOperationError", msg, &cause, file, line);
    }
    
protected:
    UnsupportedOperationError() throw() {}        
    
};    
}

#endif //SCT_UNSUPPORTEDOPERATIONERROR_H
