#ifndef SCT_STDEXCEPTIONWRAPPER_H
#define SCT_STDEXCEPTIONWRAPPER_H

#include "Exception.h"

namespace Sct {
  
    
class StdExceptionWrapper : public Exception {
public:
    /**
      Creates an Exception with message msg and no cause
      */
    StdExceptionWrapper(const std::exception& exception) throw() {
	initialize("STD_ERROR", "Sct::StdExceptionWrapper", exception.what(), 0, "Unknown", 0);
    }
    /**
      Creates an Exception with message msg and no cause, but with a file and line
      */
    StdExceptionWrapper(const std::exception& exception, const string& file, unsigned line) throw() {
	initialize("STD_ERROR", "Sct::StdExceptionWrapper", exception.what(), 0, file, line);
    }
    
};

    
}

#endif //SCT_STDEXCEPTIONWRAPPER_H
