#include "SctNames.h"

#include <mrs/message.h>
#include <cstdlib>

using namespace std;

namespace Sct {

string SctNames::getPartitionName() throw() {
    return "SCT";
}

string SctNames::getEventDataName() throw() {
    return "EventData";
}

string SctNames::getFittedDataName() throw() {
    return "FittedData";
}

string SctNames::getTestDataName() throw() {
    return "TestData";
}

string SctNames::getControlDataName() throw() {
    return "ControlData";
}

string SctNames::getRetrievedDataName() throw() {
	    return "RetrievedData";
}

string SctNames::getTempDir() throw() {
    static std::string dir = getenv("SCT_SCRATCH_DIR") ? getenv("SCT_SCRATCH_DIR") : "/tmp";
    return dir;
}

std::string SctNames::getPersistentDir() throw(){
     static std::string dir = getenv("SCT_PERSISTENT_DIR") ? getenv ("SCT_PERSISTENT_DIR") : "/tmp";
     return dir;
}

std::string SctNames::getLogDir() throw(){
     static std::string dir = getenv("TDAQ_LOGS_PATH") ? getenv ("TDAQ_LOGS_PATH") : "/tmp";
     return dir;
}

string SctNames::getLocation() throw() {
    return "Oxford";
}

string SctNames::getUser() throw() {
    return "daquser";
}

IPCPartition& SctNames::getPartition() throw() {
    static IPCPartition partition (getPartitionName());
    return partition;
}

ISInfoDictionary& SctNames::getISDictionary() throw() {
    static ISInfoDictionary dictionary(getPartition());
    return dictionary;
}

MRSStream& SctNames::Mrs() {
    static MRSStream mrs(getPartition());
    return mrs;
}


}
