#include <stdio.h>
#include "CommonWithDsp/primParams.h"

#define primFunc(name) printf(" <primId name='%s' id='%d' rev='%d'/>\n", #name, name, R_##name)
#define taskFunc(name) printf(" <taskId name='%s' id='%d' rev='%d'/>\n", #name, name, R_##name)

int main() {
  printf("<?xml version=\"1.0\" ?>\n");
  printf("<primIds>\n");
  primFunc(ECHO);
  primFunc(SET_ERRMSG_MASK);
  primFunc(PAUSE_LIST);
  primFunc(EVENT_TRAP_SETUP);
  primFunc(SET_MEMORY);
  primFunc(COPY_MEMORY);
  primFunc(MEMORY_TEST);
  primFunc(SET_LED);
  primFunc(FLASH_LED);
  primFunc(SEND_DATA);
  primFunc(MODULE_MASK); // primFunc(TRIGGER_MASK);
  primFunc(SET_TRIGGER);
  primFunc(START_TASK);
  primFunc(TASK_OPERATION);
  primFunc(TEST);
  primFunc(WRITE_BUFFER);
  printf(" <!--- Last Common %d -->\n", LAST_COMMON_PRIMITIVE);

  printf(" <!--- Slave Primitives -->\n");
  primFunc(START_EVENT_TRAPPING);
  primFunc(STOP_EVENT_TRAPPING);
  primFunc(HISTOGRAM_SETUP);
  //  primFunc(RESET_APPLICATION);
  printf(" <!--- Last Slave %d -->\n", LAST_SLAVE_PRIMITIVE);

  printf(" <!-- Master Primitives -->\n");
  primFunc(RW_SLAVE_MEMORY);
  primFunc(TRANS_SERIAL_DATA);
  primFunc(START_SLAVE_EXECUTING);
  primFunc(CONFIG_SLAVE);
  primFunc(RW_REG_FIELD);
  primFunc(POLL_REG_FIELD);
  primFunc(RW_FIFO);
  primFunc(SEND_SLAVE_LIST);
  primFunc(START_SLAVE_LIST);
  primFunc(SLAVE_LIST_OP);
  primFunc(BUILD_STREAM);
  primFunc(SEND_STREAM);
  primFunc(RW_MODULE_DATA);
  primFunc(SEND_CONFIG);
  primFunc(DSP_RESET);
  primFunc(SET_ROD_MODE);
  primFunc(RW_MODULE_VARIABLE);
  primFunc(RW_BOC_DATA);
  //  func(BOC_HISTOGRAM);
  printf(" <!--- Last Master %d -->\n", LAST_MASTER_PRIMITIVE);

  printf(" <!-- Begin tasks -->\n");
  taskFunc(HISTOGRAM_CTRL_TASK);
  taskFunc(MIRROR_TASK);
  taskFunc(TRAP_REQ_TASK);
  printf(" <!--- Last Master task %d -->\n", LAST_MASTER_TASK);

  taskFunc(HISTOGRAM_TASK);
  taskFunc(TRAP_TASK);
  taskFunc(OCCUPANCY_TASK);
  taskFunc(ERROR_TASK);
  taskFunc(RESYNCH_TASK);
  printf(" <!-- Last Slave task %d -->\n", LAST_SLAVE_TASK);

  printf("</primIds>\n");

  return 0;
}

