class Type:
    def __init__(self):
        self.name = "unnamed"
        self.type = "untyped"

    def copy(copy):
        newType = Type()
        newType.type = copy.type
        return newType

    def addArray(self, size):
#        print "Add array to ", self.name
        try:
            self.array.append(size)
#            print " another dimension "
        except:
            self.array = [size]
#            print " first dimension "
#        print self, self.array

    def makeStruct(self):
        self.struct = 1

    def setName(self, name):
        self.name = name

    def setBaseType(self, type):
        self.type = type

    def setFieldWidth(self, size):
        self.fieldWidth = size

    def makePointer(self):
        self.pointer = 1
        
    def __repr__(self):
        additional = ""
        try:
            if(self.struct == 1):
                additional += " is struct"
        except:
            pass
        try:
            if(self.pointer == 1):
                additional += " is pointer"
        except:
            pass
        try:
            if(self.fieldWidth):
                additional += " has field width %d" % self.fieldWidth
        except:
            pass

        try:
            for a in self.array:
                additional += " has array size %d" % a
        except:
            pass
        return "%s %s %s" % (self.type, self.name, additional)

    def asXmlNode(self, doc):
        typeNode = doc.createElement("type")

        typeNode.setAttribute("name", self.name)
        typeNode.setAttribute("base", self.type)

        try:
            if(self.struct == 1):
                typeNode.setAttribute("struct", "true")
        except:
            pass

        try:
            if(self.pointer == 1):
                typeNode.setAttribute("pointer", "true")
        except:
            pass

        try:
            if(self.fieldWidth):
                typeNode.setAttribute("fieldWidth", self.fieldWidth)
        except:
            pass

        try:
            arrayNode = doc.createElement("array")
            for a in self.array:
                aNode = doc.createElement("dimension")
                dim = aNode.setAttribute("size", "%d" % a)
                arrayNode.appendChild(aNode)
            typeNode.appendChild(arrayNode)
        except AttributeError:
            pass

        return typeNode
       
