import sys
import re
import type

processedFile = sys.stdin # open(argv[1], 'r')

count = 0
singleTokens = "(?:[;,*:{}\\[\\]])"
word = '(?:[_a-zA-Z]\w*)'
number = '(?:\d+)'
allTokens = "(%s)" % "|".join([singleTokens, word, number])

tokens = []

regexpString = allTokens
regA = re.compile(regexpString)
numberRe = re.compile(number)

matchTypedef = re.compile(" *typedef .*;$")

for a in processedFile.readlines():
    if(matchTypedef.match(a)):
        continue
    a = regA.split(a)

    a = filter(lambda x: x.strip(" \n"), a)

    for i in filter(lambda x: x!='', a):
        tokens.append(i)

expect = "struct_typedef"

level = 0
number_in_field = 0
number_in_array = 0

struct_is_union = 0
struct_is_enum = 0

structs = {}
unions = {}
types = {}

currentStructName = ""
currentStruct = []
currentType = type.Type()

for t in tokens:
    # print t
    # Skip enums...
    if(struct_is_enum):
        if(t != ";"):
            continue
        else:
            struct_is_enum = 0
            expect = "struct_typedef"
            continue

    if(re.compile("^struct$|^union$").match(t)):
        if(t == "union"):
            struct_is_union = 1
        if(expect.find("struct") == -1):
            if(expect.find("tid") != -1):
                expect = "tid"
            else:
                print "Found 'struct' when expecting", expect
                expect = "stName_open"
        else:
            expect = "stName_open"
    elif(t == "enum"):
        struct_is_enum = 1
        if(expect.find("struct") == -1):
            if(expect.find("tid") != -1):
                expect = "tid"
            else:
                print "Found 'enum' when expecting", expect
                expect = "stName_open"
    elif("typedef" == t):
        if(expect.find("typedef") == -1):
            print "Found 'typedef' when expecting", expect
        expect = "struct"
    elif(t == "{"):
        if(expect.find("open") == -1):
            print "Found open when expecting", expect
        expect = "tid"
        level = level + 1
    elif(t == "}"):
        if(expect.find("close") == -1):
            print "Found close when expecting", expect
        expect = "semi_stName"
        closingStructure = 1
        level = level - 1
        if(level < 0):
            print "*** Parse error: too many }\n"
    elif(t == ";"):
        if(expect.find("semi") == -1):
            print "Found semi when expecting", expect
        # Closing structure
        if(level > 0):
            expect = "tid_close"
            currentType = type.Type()
        else:
            if(struct_is_union == 1):
                struct_is_union = 0
                unions[currentStructName] = currentStruct
            else:
                structs[currentStructName] = currentStruct
            currentStructName = ""
            closingStructure = 0
            currentStruct = []
            expect = "struct_typedef"
    elif(t == ":"):
        if(expect.find("colon") == -1):
            print "Found colon when expecting", expect
        number_in_field = 1
        expect = "number"
    elif(t == ","):
        if(expect.find("comma") == -1):
            print "Found comma when expecting", expect
        currentType = type.Type.copy(currentType)
        expect = "var_pointer"
    elif(t == "["):
        if(expect.find("osquare") == -1):
            print "Found '[' when expecting", expect
        number_in_array = 1
        expect = "number"
    elif(t == "]"):
        if(expect.find("csquare") == -1):
            print "Found ']' when expecting", expect
        if(number_in_array):
            currentType.addArray(-1)
            number_in_array = 0
        expect = "semi_comma_osquare"
    elif(numberRe.match(t)):
        if(expect.find("number") == -1):
            print "Found number when expecting", expect
        # Depending on whether its in an array or a field spec 
        if(number_in_array):
            currentType.addArray(int(t))
            number_in_array = 0
        elif(number_in_field):
            currentType.setFieldWidth(t)
            number_in_field = 0
        else:
            print "Found number in unexpected place"
            
        expect = "csquare_semi"
    elif(t == "*"):
        if(expect.find("pointer") == -1):
            print "Found '*' when expecting", expect
        # Depending on whether its in an array or a field spec 
        expect = "var"
        currentType.makePointer()
    else:
        if(expect.find("stName") != -1):
            expect = "semi_open"
            currentStructName = t
        elif(expect.find("var") != -1):

            currentType.setName(t)
            currentStruct.append(currentType)

            expect = "semi_comma_osquare_colon"
        elif(expect.find("tid") != -1):
            currentType.setBaseType(t)
            try:
                types[t] += 1
            except:
                types[t] = 1

            expect = "var_pointer"
        else:
            print "Found word expected:", expect


from xml.dom.minidom import Document
from xml.dom import minidom

idsDoc = minidom.parse("xmlPrimList.xml")

idMap = {}
taskMap = {}

for idNode in idsDoc.firstChild.getElementsByTagName('primId'):
    if(idNode.nodeType == idNode.ELEMENT_NODE):
        name = idNode.attributes["name"].value
        id = idNode.attributes["id"].value
        rev = idNode.attributes["rev"].value

        idMap[name] = (id, rev)

for idNode in idsDoc.firstChild.getElementsByTagName('taskId'):
    if(idNode.nodeType == idNode.ELEMENT_NODE):
        name = idNode.attributes["name"].value
        id = idNode.attributes["id"].value
        rev = idNode.attributes["rev"].value

        taskMap[name] = (id, rev)

doc = Document()
rootNode = doc.createElement("structs")

# Build XML file
for a in structs:
    if(a.endswith("_IN") or a.endswith("_OUT")):
        rootName = a[0:a.rfind("_")]


        if(rootName.endswith("_TASK")):
            structNode = doc.createElement("task")
            try:
                (id, rev) = taskMap[rootName]
                structNode.setAttribute("ID", id)
                structNode.setAttribute("rev", rev)
            except KeyError:
                pass
            rootName = rootName[0:rootName.rfind("_")]
        else:
            structNode = doc.createElement("primitive")
            try:
                (id, rev) = idMap[rootName]
                structNode.setAttribute("ID", id)
                structNode.setAttribute("rev", rev)
            except KeyError:
                pass

        if(a.endswith("_IN")):
            structNode.setAttribute("dir", "IN")
        else:
            structNode.setAttribute("dir", "OUT")

        structNode.setAttribute("root", rootName)
    else:
        structNode = doc.createElement("struct")
    structNode.setAttribute("name", a)
    # List types in struct
    for b in structs[a]:
        structNode.appendChild(b.asXmlNode(doc))
    rootNode.appendChild(structNode)

doc.appendChild(rootNode)

output = open("primParams.xml", 'w')
output.write(doc.toprettyxml(indent = "  "))

#print "Used types named:\n"
#for a in types:
#    print a, ": ", types[a]
