#ifndef SCT_OSTREAMADAPTOR_H
#define SCT_OSTREAMADAPTOR_H

#include "OStream.h"
#include <iostream>
#include <string>
#include <cstring>

using std::ostream;
using std::string;
using std::strcpy;

namespace Sct {

  /**
     Adaptor for making a SCT::OStream from a std::ostream.
  */

class OStreamAdaptor : public virtual OStream {
public:
  /* constructor from a std::ostream */
    OStreamAdaptor(ostream& os) : os(&os) {
    }
    
    virtual ~OStreamAdaptor() {
    }
    
    virtual OStream & operator<<(bool val) {
	*os << val << " ";
	return *this;
    }
    
    virtual OStream & operator<<(char val) {
	*os << (int)val << " ";
	return *this;
    }
    
    virtual OStream & operator<<(unsigned char val) {
	*os << (unsigned int)val << " ";
	//cout << "WriteUChar: " << (int)val << " at: " << *os.tellp() << endl;
	return *this;
    }
    
    virtual OStream & operator<<(short val) {
	*os << val << " ";
	return *this;
    }
    
    virtual OStream & operator<<(unsigned short val){
	*os << val << " ";
	return *this;
    }
    
    virtual OStream & operator<<(int val) {
	*os << val << " ";
	return *this;
    }
    
    virtual OStream & operator<<(unsigned int val) {
	*os << val << " ";
	return *this;
    }
    
    virtual OStream & operator<<(long val) {
	*os << val << " ";
	return *this;
    }
    
    virtual OStream & operator<<(unsigned long val) {
	*os << val << " ";
	return *this;
    }
    
    virtual OStream & operator<<(double val) {
	*os << val << " ";
	return *this;
    }
    
    virtual OStream & operator<<(float val) {
	*os << val << " ";
	return *this;
    }
    
    virtual OStream & operator<<(const std::string & val) {
	*os << val << " ";
	return *this;
    }
    
//    virtual OStream & operator<<(OWLDate & val)  = 0;
//    virtual OStream & operator<<(OWLTime & val)  = 0;

    virtual OStream & operator<<(const char * str) {
	*os << str << " ";
	return *this;
    }
    
    virtual OStream & operator<<(const unsigned char * str) {
	*os << str << " ";
	return *this;
    }
    
    virtual OStream & put(const bool* p, size_t size) {
	*os << size << " ";
	for (unsigned int i=0; i<size; ++i) {
	    *os << p[i] << " ";
	}
	return *this;
    }
    
    virtual OStream & put(const char* p, size_t size) {
	*os << size << " ";
	for (unsigned int i=0; i<size; ++i) {
	    *os << (int)p[i] << " ";
	}
	return *this;
    }
    
    virtual OStream & put(const unsigned char* p, size_t size) {
	*os << size << " ";
	for (unsigned int i=0; i<size; ++i) {
	    *os << (int)p[i] << " ";
	}
	return *this;
    }
  
    virtual OStream & put(const short* p, size_t size) {
	*os << size << " ";
	for (unsigned int i=0; i<size; ++i) {
	    *os << p[i] << " ";
	}
	return *this;
    }
  
    virtual OStream & put(const unsigned short* p, size_t size) {
	*os << size << " ";
	for (unsigned int i=0; i<size; ++i) {
	    *os << p[i] << " ";
	}
	return *this;
    }
  
    virtual OStream & put(const int* p, size_t size) {
	*os << size << " ";
	for (unsigned int i=0; i<size; ++i) {
	    *os << p[i] << " ";
	}
	return *this;
    }
  
    virtual OStream & put(const unsigned int* p, size_t size) {
	*os << size << " ";
	for (unsigned int i=0; i<size; ++i) {
	    *os << p[i] << " ";
	}
	return *this;
    }
  
    virtual OStream & put(const long* p, size_t size) {
	*os << size << " ";
	for (unsigned int i=0; i<size; ++i) {
	    *os << p[i] << " ";
	}
	return *this;
    }
  
    virtual OStream & put(const unsigned long* p, size_t size) {
	*os << size << " ";
	for (unsigned int i=0; i<size; ++i) {
	    *os << p[i] << " ";
	}
	return *this;
    }
  
    virtual OStream & put(const float* p, size_t size) {
	*os << size << " ";
	for (unsigned int i=0; i<size; ++i) {
	    *os << p[i] << " ";
	}
	return *this;
    }
  
    virtual OStream & put(const double* p, size_t size) {
	*os << size << " ";
	for (unsigned int i=0; i<size; ++i) {
	    *os << p[i] << " ";
	}
	return *this;
    }
  
    virtual OStream & put(const std::string* p, size_t size) {
      *os << size << " ";
      for (unsigned int i=0; i<size; ++i) {
	*os << p[i] << " ";
      }
      return *this;
    }
//    virtual OStream & put(const OWLDate* p, size_t size) = 0;
//    virtual OStream & put(const OWLTime* p, size_t size) = 0;
    
private:
    ostream *os;
    OStreamAdaptor(){}
};

}
#endif //SCT_OSTREAMADAPTOR_H
