#ifndef SCT_OSTREAM_H
#define SCT_OSTREAM_H

#include <string>

namespace Sct {

  /** Output stream interface for Sct::Streamer s. Primitive type shift << and put operators. */
    
class OStream {
public:
    virtual OStream & operator<<(bool val) = 0;
    virtual OStream & operator<<(char val) = 0;
    virtual OStream & operator<<(unsigned char val)  = 0;
    virtual OStream & operator<<(short val)  = 0;
    virtual OStream & operator<<(unsigned short val)  = 0;
    virtual OStream & operator<<(int val)  = 0;
    virtual OStream & operator<<(unsigned int val)  = 0;
    virtual OStream & operator<<(long val)  = 0;
    virtual OStream & operator<<(unsigned long val)  = 0;
    virtual OStream & operator<<(double val) = 0;
    virtual OStream & operator<<(float val)  = 0;
    virtual OStream & operator<<(const std::string & val)  = 0;
//    virtual OStream & operator<<(OWLDate & val)  = 0;
//    virtual OStream & operator<<(OWLTime & val)  = 0;

    virtual OStream & operator<<(const char * str)  = 0;
    virtual OStream & operator<<(const unsigned char * str)  = 0;
    
    virtual OStream & put(const bool* p, size_t size) = 0;
    virtual OStream & put(const char* p, size_t size) = 0;
    virtual OStream & put(const unsigned char* p, size_t size) = 0;
    virtual OStream & put(const short* p, size_t size) = 0;
    virtual OStream & put(const unsigned short* p, size_t size) = 0;
    virtual OStream & put(const int* p, size_t size) = 0;
    virtual OStream & put(const unsigned int* p, size_t size) = 0;
    virtual OStream & put(const long* p, size_t size) = 0;
    virtual OStream & put(const unsigned long* p, size_t size) = 0;
    virtual OStream & put(const float* p, size_t size) = 0;
    virtual OStream & put(const double* p, size_t size) = 0;
    virtual OStream & put(const std::string* p, size_t size) = 0;
//    virtual OStream & put(const OWLDate* p, size_t size) = 0;
//    virtual OStream & put(const OWLTime* p, size_t size) = 0;
};
}
#endif
