#ifndef SCT_IPCEXCEPTION_H    
#define SCT_IPCEXCEPTION_H

#include <ilu/ilu.hh>
#include "IoExceptions.h"

namespace Sct {

/**
 * Thrown to indicate an error with an Ipc call.
 * @ingroup Exceptions     
 * @author Alan Barr 
 */
class IpcException : public IoException {
public:
    /**
      Creates an Exception with message msg and no cause
      */
    IpcException(const ilu_Exception& error, const string& msg, const string& file, int line) throw();
    
    /**
      Creates an Exception with a cause.  Useful for simply wrapping
      exceptions.
      */
    IpcException(const ilu_Exception& error, Throwable& cause, const string& file, int line) throw();
    
    /**
      Creates an Exception with a message and a cause
      */
    IpcException(const ilu_Exception& error, const string& msg, Throwable& cause, const string& file, int line) throw();
    
    ///Get the Ilu message
    const ilu_Exception& getIluException() const throw();
    virtual shared_ptr<Throwable> clone() const throw();
    virtual string getMessage() const throw();
        
protected:
    ilu_Exception iluMsg;			///< Holds the ILU message
    IpcException() throw() {}   
};
}
#endif //SCT_IPCEXCEPTION_H
