#include "IoExceptions.h"

namespace Sct {

//IoException methods
IoException::IoException(const string& msg, const string& file, int line) throw() {
    initialize("IO_EXCEPTION", "Sct::IoException", msg, 0, file, line);
}

IoException::IoException(Throwable& cause, const string& file, int line) throw() {
    initialize("IO_EXCEPTION", "Sct::IoException", "", &cause, file, line);
}

IoException::IoException(const string& msg, Throwable& cause, const string& file, int line) throw() {
    initialize("IO_EXCEPTION", "Sct::IoException", msg, &cause, file, line);
}

//IsException methods
IsException::IsException(int status, const string& msg, const string& file, int line) throw() : status(status) {
    initialize("IS_EXCEPTION", "Sct::IsException", msg, 0, file, line);
}

IsException::IsException(int status, Throwable& cause, const string& file, int line) throw() : status(status) {
    initialize("IS_EXCEPTION", "Sct::IsException", "", &cause, file, line);
}

IsException::IsException(int status, const string& msg, Throwable& cause, const string& file, int line) throw() : status(status) {
    initialize("IS_EXCEPTION", "Sct::IsException", msg, &cause, file, line);
}
    
int IsException::getStatus() const throw() {
    return status;
}

shared_ptr<Throwable> IsException::clone() const throw() {
    return shared_ptr<Throwable>(new IsException(*this));
}

string IsException::getMessage() const throw() {
    std::ostringstream output;
    output << msg << " [Status = " << status << "]";
    return output.str();
}

//FileException methods
FileException::FileException(const string& fileName, const string& msg, const string& file, int line) throw() : fileName(fileName) {
    initialize("FILE_EXCEPTION", "Sct::FileException", msg, 0, file, line);
}    

FileException::FileException(const string& fileName, Throwable& cause, const string& file, int line) throw() : fileName(fileName) {
    initialize("FILE_EXCEPTION", "Sct::FileException", "", &cause, file, line);
}    

FileException::FileException(const string& fileName, const string& msg, Throwable& cause, const string& file, int line) throw() : fileName(fileName) {
    initialize("FILE_EXCEPTION", "Sct::FileException", msg, &cause, file, line);
}    

    
const string& FileException::getFileName() const throw() {
    return fileName;
}

shared_ptr<Throwable> FileException::clone() const throw() {
    return shared_ptr<Throwable>(new FileException(*this));
}

string FileException::getMessage() const throw() {
    std::ostringstream output;
    output << msg << " [File = " << fileName << "]";
    return output.str();
}


//SteamCorruptedException methods
StreamCorruptedException::StreamCorruptedException(const string& msg, const string& file, int line) throw() {
    initialize("STREAM_EXCEPTION", "Sct::StreamCorruptedException", msg, 0, file, line);
}

StreamCorruptedException::StreamCorruptedException(Throwable& cause, const string& file, int line) throw() {
    initialize("STREAM_EXCEPTION", "Sct::StreamCorruptedException", "", &cause, file, line);    
}

StreamCorruptedException::StreamCorruptedException(const string& msg, Throwable& cause, const string& file, int line) throw() {
    initialize("STREAM_EXCEPTION", "Sct::StreamCorruptedException", msg, &cause, file, line);    
}




//NoSuchStreamerException methods
NoSuchStreamerException::NoSuchStreamerException(const string& className, const string& msg, 
						 const string& file, int line) throw() : className(className) {
    initialize("NO_STREAMER", "Sct::NoSuchStreamerException", msg, 0, file, line);
}

    
NoSuchStreamerException::NoSuchStreamerException(const string& className, Throwable& cause, const string& file, 
						 int line) throw() : className(className) {
    initialize("NO_STREAMER", "Sct::NoSuchStreamerException", "", &cause, file, line);
}

    
NoSuchStreamerException::NoSuchStreamerException(const string& className, const string& msg, Throwable& cause, 
						 const string& file, int line) throw() : className(className) {
    initialize("NO_STREAMER", "Sct::NoSuchStreamerException", msg, &cause, file, line);
}

const string& NoSuchStreamerException::getClassName() const throw() {
    return className; 
}

shared_ptr<Throwable> NoSuchStreamerException::clone() const throw() {
    return shared_ptr<Throwable> (new NoSuchStreamerException(*this));
}

string NoSuchStreamerException::getMessage() const throw() {
    return msg + " ClassName: " + className;
}

}

