#ifndef SCT_ISTREAMADAPTOR_H
#define SCT_ISTREAMADAPTOR_H

#include "IStream.h"

#include <iostream>
#include <cstring>
#include <string>

using std::istream;
using std::string;
using std::strcpy;

namespace Sct {

template<typename T>
  T min(T a, T b){
  return a < b ? a : b;
  }

template<typename T>
void getArray(istream& stream, T* p, size_t size, size_t actualSize);

template<typename T>
void getArrayCreate(istream& stream, T** p, size_t& size);

template<typename T>
void getArrayNoCreate(istream& stream, T* p, size_t size);

/** Adaptor for making a Sct::IStream from a std::istream. */

class IStreamAdaptor : public virtual IStream {
public:
  /** constructor from a std::istream */
    IStreamAdaptor(istream& stream) : istr(&stream) {
    }

    virtual ~IStreamAdaptor() {
    }

    virtual IStream & operator>>(char *str) {
        *istr >> str;
	//cout << "Read: " << str << endl;
        return *this;
    }

    virtual IStream & operator>>(unsigned char *str) {
        *istr >> str;
	//cout << "Read: " << str << endl;	
	return *this;
    }

    virtual IStream & operator>>(char **str) {
        string inStr;
        *istr >> inStr;
        *str = new char[inStr.length()+1];
        strcpy(*str, inStr.c_str());
	//cout << "Read: " << *str << endl;	
	return *this;
    }

    virtual IStream & operator>>(unsigned char **str)  {
        string inStr;
        *istr >> inStr;
        char* str2 = new char[inStr.length()+1];
        strcpy(str2, inStr.c_str());
        *str = reinterpret_cast<unsigned char*>(str2);
	//cout << "Read: " << *str << endl;	
	return *this;
    }

    virtual IStream & operator>>(bool& val) {
        *istr >> val;
        return *this;
    }

    virtual IStream & operator>>(char& val) {
	int temp = 0;
        *istr >> temp;
	val = (char)val;
        return *this;
    }

    virtual IStream & operator>>(unsigned char& val) {
	unsigned int temp = 0;
        *istr >> temp;
	val = (unsigned char)temp;
	//cout << "ReadUChar: " << (int)val << " at: " << *istr.tellg() << " temp: " << temp << endl;	
        return *this;
    }

    virtual IStream & operator>>(short& val) {
        *istr >> val;
        return *this;
    }

    virtual IStream & operator>>(unsigned short& val) {
        *istr >> val;
        return *this;
    }

    virtual IStream & operator>>(int& val) {
        *istr >> val;
        return *this;
    }

    virtual IStream & operator>>(unsigned int& val) {
        *istr >> val;
        return *this;
    }

    virtual IStream & operator>>(long& val)  {
        *istr >> val;
        return *this;
    }

    virtual IStream & operator>>(unsigned long& val) {
        *istr >> val;
        return *this;
    }

    virtual IStream & operator>>(float& val) {
        *istr >> val;
        return *this;
    }

    virtual IStream & operator>>(double& val) {
        *istr >> val;
        return *this;
    }

    virtual IStream & operator>>(std::string& val) {
        *istr >> val;
        return *this;
    }

    //    virtual IStream & operator>>(OWLDate& val) = 0;
    //    virtual IStream & operator>>(OWLTime& val) = 0;


    virtual IStream & get ( bool ** p, size_t & size ) {
	getArrayCreate(*istr, p, size);
        return *this;
    }

    virtual IStream & get ( char ** p, size_t & size ) {
	getArrayCreate(*istr, p, size);
        return *this;
    }

    virtual IStream & get ( unsigned char ** p, size_t & size ) {
	getArrayCreate(*istr, p, size);
	return *this;
    }

    virtual IStream & get( short ** p, size_t & size ) {
	getArrayCreate(*istr, p, size);
	return *this;
    }

    virtual IStream & get( unsigned short ** p, size_t & size ) {
	getArrayCreate(*istr, p, size);
        return *this;
    }

    virtual IStream & get( int ** p, size_t & size ) {
	getArrayCreate(*istr, p, size);
        return *this;
    }

    virtual IStream & get( unsigned int ** p, size_t & size ) {
	getArrayCreate(*istr, p, size);
        return *this;
    }

    virtual IStream & get( long ** p, size_t & size ) {
	getArrayCreate(*istr, p, size);
        return *this;
    }

    virtual IStream & get( unsigned long ** p, size_t & size ) {
	getArrayCreate(*istr, p, size);
        return *this;
    }

    virtual IStream & get( float ** p, size_t & size ) {
	getArrayCreate(*istr, p, size);
        return *this;
    }

    virtual IStream & get( double ** p, size_t & size ) {
	getArrayCreate(*istr, p, size);
        return *this;
    }

    virtual IStream & get( std::string ** p, size_t & size ) {
	getArrayCreate(*istr, p, size);
        return *this;
    }

    //    virtual IStream & get( OWLDate ** p, size_t & size ) = 0;
    //    virtual IStream & get( OWLTime ** p, size_t & size ) = 0;

    virtual IStream & get( bool * const p, const size_t size ) {
        getArrayNoCreate(*istr, p, size);
        return *this;
    }

    virtual IStream & get( char * const p, const size_t size ) {
        getArrayNoCreate(*istr, p, size);        
	return *this;
    }

    virtual IStream & get( unsigned char * const p, const size_t size ) {
        getArrayNoCreate(*istr, p, size);        
	return *this;
    }

    virtual IStream & get( short * const p, const size_t size ) {
        getArrayNoCreate(*istr, p, size);        
	return *this;
    }

    virtual IStream & get( unsigned short * const p, const size_t size ) {
        getArrayNoCreate(*istr, p, size);        
	return *this;
    }

    virtual IStream & get( int * const p, const size_t size ) {
        getArrayNoCreate(*istr, p, size);        
	return *this;
    }

    virtual IStream & get( unsigned int * const p, const size_t size ) {
        getArrayNoCreate(*istr, p, size);        
	return *this;
    }

    virtual IStream & get( long * const p, const size_t size ) {
        getArrayNoCreate(*istr, p, size);
	return *this;
    }

    virtual IStream & get( unsigned long * const p, const size_t size ) {
        getArrayNoCreate(*istr, p, size);
        return *this;
    }

    virtual IStream & get( float * const p, const size_t size ) {
        getArrayNoCreate(*istr, p, size);
        return *this;
    }

    virtual IStream & get( double * const p, const size_t size ) {
        getArrayNoCreate(*istr, p, size);
        return *this;
    }

    virtual IStream & get( std::string * const p, const size_t size ) {
        getArrayNoCreate(*istr, p, size);
        return *this;
    }

    //    virtual IStream & get( OWLDate * const p, const size_t size ) = 0;
    //    virtual IStream & get( OWLTime * const p, const size_t size ) = 0;

private:
    istream *istr;
    IStreamAdaptor();
};

template<typename T>
inline void getArray(istream& istr, T* p, size_t size, size_t actualSize) {
    size_t copySize = min(size, actualSize);
    for (unsigned int i=0; i<copySize; ++i) {
        istr >> p[i];
    }
    for (unsigned int i=size; i<actualSize; ++i) {
        T temp;
        istr >> temp;
    }
}

inline void getArray(istream& istr, char* p, size_t size, size_t actualSize) {
    int temp;
    size_t copySize = min(size, actualSize);
    for (unsigned int i=0; i<copySize; ++i) {
        istr >> temp;
	p[i] = (char)temp;
    }
    for (unsigned int i=size; i<actualSize; ++i) {
        istr >> temp;
    }
}

inline void getArray(istream& istr, unsigned char* p, size_t size, size_t actualSize) {
    int temp;
    size_t copySize = min(size, actualSize);
    for (unsigned int i=0; i<copySize; ++i) {
        istr >> temp;
	p[i] = (unsigned char)temp;
    }
    for (unsigned int i=size; i<actualSize; ++i) {
        istr >> temp;
    }
}


template<typename T>
inline void getArrayCreate(istream& istr, T** p, size_t& size) {
    istr >> size;
    *p = new T[size];
    getArray(istr, *p, size, size);
}

template<typename T>
inline void getArrayNoCreate(istream& istr, T* p, size_t size) {
    size_t actualSize = 0;
    istr >> actualSize;
    getArray(istr, p, size, actualSize);
}

}
#endif //SCT_ISTREAMADAPTOR_H
