#ifndef SCT_ISTREAM_H
#define SCT_ISTREAM_H

namespace Sct {
    
  /** Input steam interface for Sct::Streamer s. Primitive type shift >> and get operators. */

class IStream {
public:
    
    virtual IStream & operator>>(char *str) = 0;
    virtual IStream & operator>>(unsigned char *str) = 0;
    
    virtual IStream & operator>>(char **str) = 0;
    virtual IStream & operator>>(unsigned char **str) = 0;
    
    virtual IStream & operator>>(bool& val) = 0;
    virtual IStream & operator>>(char& val) = 0;
    virtual IStream & operator>>(unsigned char& val) = 0;
    virtual IStream & operator>>(short& val)  = 0;
    virtual IStream & operator>>(unsigned short& val)  = 0;
    virtual IStream & operator>>(int& val)  = 0;
    virtual IStream & operator>>(unsigned int& val)  = 0;
    virtual IStream & operator>>(long& val)  = 0;
    virtual IStream & operator>>(unsigned long& val)  = 0;
    virtual IStream & operator>>(float& val) = 0;
    virtual IStream & operator>>(double& val) = 0;
    virtual IStream & operator>>(std::string& val) = 0;
//    virtual IStream & operator>>(OWLDate& val) = 0;
//    virtual IStream & operator>>(OWLTime& val) = 0;
    
    
    virtual IStream & get( bool ** p, size_t & size ) = 0;
    virtual IStream & get( char ** p, size_t & size ) = 0;
    virtual IStream & get( unsigned char ** p, size_t & size ) = 0;
    virtual IStream & get( short ** p, size_t & size ) = 0;
    virtual IStream & get( unsigned short ** p, size_t & size ) = 0;
    virtual IStream & get( int ** p, size_t & size ) = 0;
    virtual IStream & get( unsigned int ** p, size_t & size ) = 0;
    virtual IStream & get( long ** p, size_t & size ) = 0;
    virtual IStream & get( unsigned long ** p, size_t & size ) = 0;
    virtual IStream & get( float ** p, size_t & size ) = 0;
    virtual IStream & get( double ** p, size_t & size ) = 0;
    virtual IStream & get( std::string ** p, size_t & size ) = 0;
//    virtual IStream & get( OWLDate ** p, size_t & size ) = 0;
//    virtual IStream & get( OWLTime ** p, size_t & size ) = 0;
    
    virtual IStream & get( bool * const p, const size_t size ) = 0;
    virtual IStream & get( char * const p, const size_t size ) = 0;
    virtual IStream & get( unsigned char * const p, const size_t size ) = 0;
    virtual IStream & get( short * const p, const size_t size ) = 0;
    virtual IStream & get( unsigned short * const p, const size_t size ) = 0;
    virtual IStream & get( int * const p, const size_t size ) = 0;
    virtual IStream & get( unsigned int * const p, const size_t size ) = 0;
    virtual IStream & get( long * const p, const size_t size ) = 0;
    virtual IStream & get( unsigned long * const p, const size_t size ) = 0;
    virtual IStream & get( float * const p, const size_t size ) = 0;
    virtual IStream & get( double * const p, const size_t size ) = 0;
    virtual IStream & get( std::string * const p, const size_t size ) = 0;
//    virtual IStream & get( OWLDate * const p, const size_t size ) = 0;
//    virtual IStream & get( OWLTime * const p, const size_t size ) = 0;	
};
    
}

#endif //SCT_ISTREAM_H
