#include "ISProxyStreamer.h"
#include "ISProxy.h"
#include "../IOManager.h"
#include "../File/IOManagerFile.h"
#include <memory>

using namespace Sct::File;
using namespace std;

namespace Sct {
namespace ISProxy { 
    
unsigned ISProxyStreamer::s_version=1;
	
ISProxyStreamer::ISProxyStreamer() throw () {}    
bool ISProxyStreamer::inMap = IOManager::addToMap("Sct::ISProxy::ISProxy", auto_ptr<Streamer>(new ISProxyStreamer())); 

void ISProxyStreamer::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    const ISProxy& var = dynamic_cast<const ISProxy&>(ob);
    out << var.getFileName();
}

shared_ptr<Streamable> ISProxyStreamer::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    string fileName;
    in >> fileName;
    
    return IOManagerFile::instance().read(fileName);
}

void ISProxyStreamer::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    ISProxy& var = dynamic_cast<ISProxy&>(ob);
    string fileName;
    in >> fileName;
    var.setFileName(fileName);
}


    
}
}
