#include "IOManagerISProxy.h"
#include "ISProxy.h"
#include "../File/IOManagerFile.h"
#include "../OStream.h"
#include "../Streamer.h"

using namespace Sct::File;

namespace Sct {
namespace ISProxy { 

IOManagerISProxy::IOManagerISProxy() throw() {
}
    
IOManagerISProxy& IOManagerISProxy::instance() {
    static IOManagerISProxy theInstance;
    return theInstance;
}
    
void IOManagerISProxy::write(const Serializable& ob, const IOParams* params) const throw(LogicError, IoError) {
    const ISProxy* proxy = dynamic_cast<const ISProxy*>(&ob);
    if (!proxy) {
        ISProxy proxy(ob.getUniqueID(), ob.getClassName());
        IOManagerFile::instance().write(ob);    
        IOManagerIS::write(proxy, params);
    } else {
        IOManagerIS::write(*proxy, params);
    }
}

void IOManagerISProxy::writeImpl(OStream& out, const Streamable& ob, bool bWriteClassName) const throw(LogicError, IoError) {
    //cout << "IOManagerISProxy::writeImpl" << &ob << endl;
    const ISProxy* proxy = dynamic_cast<const ISProxy*>(&ob);
    if (proxy) {
	if (bWriteClassName) writeClassName(out, "Sct::ISProxy::ISProxy");
	Streamer& proxyStreamer = getStreamer("Sct::ISProxy::ISProxy");
	proxyStreamer.write(out, ob, *this);
    } else {
	IOManagerIS::writeImpl(out, ob, bWriteClassName);
    }
}
    
}
}
