#include "IONameIS.h"
#include "../SctNames.h"

namespace Sct {
namespace IS {

string IONameIS::defaultServer = SctNames::getEventDataName();    
    
IONameIS::IONameIS(const string& nameIO) throw(InvalidArgument) : IOName(nameIO) {
    IONameIS::parse();
}

IONameIS::IONameIS() {
}


IONameIS::IONameIS(const string& uniqueID, const string& className) throw() : IOName(uniqueID, className), server(defaultServer) {
    IONameIS::construct();
}

IONameIS::IONameIS(const string& uniqueID, const string& className, const string& server) throw() : IOName(uniqueID, className), server(server) {
    IONameIS::construct();    
}

IONameIS::~IONameIS() throw() {
}
   

string IONameIS::getRegExp(const string& className) throw() {
    string regExp = ".*";
    regExp += className;
    regExp += ".*";
    return regExp;
}

void IONameIS::parse() throw(InvalidArgument) {
    int dot = nameIO.find('.');
    server = nameIO.substr(0, dot);
    int dot2 = nameIO.find('.', ++dot);
    className = nameIO.substr(dot, dot2-dot);  //ClassName is everything between the first . and second .
    uniqueID = nameIO.substr(++dot2);
}

void IONameIS::construct() throw() {
    nameIO = server;
    nameIO += ".";
    nameIO += className;
    nameIO += ".";
    nameIO += uniqueID;    
}

void IONameIS::setServer(const string& server) throw() {
    this->server = server;
    construct();
}

string IONameIS::getServer() const throw() {
    return server;
}

string IONameIS::getDefaultServer() throw() {
    return defaultServer;
}

void IONameIS::setDefaultServer(const string& server) throw() {
    defaultServer = server;
} 
}
}
