#ifndef SCT_IS_IOMANAGERIS_H
#define SCT_IS_IOMANAGERIS_H

#include <is/isinfo.h>
#include "../IOManager.h"
#include "../IoExceptions.h"
#include "../LogicErrors.h"

namespace Sct {
namespace IS {
/** IOManager implimentation which writes to the online software information service */    
class IOManagerIS : public IOManager {
public:
    static IOManagerIS& instance() throw();
    
    virtual void write(const Serializable& ob, const IOParams* params = 0) const throw(LogicError, IoError);
    virtual shared_ptr<Serializable> read(const string& name, const IOParams* params = 0) const throw(LogicError, IoError);
    virtual shared_ptr<Serializable> read(const ISCallbackInfo& info) const throw(LogicError, IoError);
    virtual shared_ptr<Serializable> read(ISInfoIterator& it) const throw(LogicError, IoError);
    
protected:
    IOManagerIS() throw();
};

/** IOParams which contans the servername of the object access through IONameIS*/

class IOParamsIS : public IOParams {
public:
    IOParamsIS(const string& serverName) : serverName(serverName) {}
    
    string serverName;
};

}
}

#endif //SCT_IS_IOMANAGERIS_H
