#include "IOName.h"

namespace Sct {
    
IOName::IOName(const string& nameIO) throw(InvalidArgument) : nameIO(nameIO) , m_wildcardsExpanded(false){
}
	
IOName::IOName(const string& uniqueID, const string& className) throw(InvalidArgumentError) : uniqueID(uniqueID), className(className), m_wildcardsExpanded(false){
}

IOName::~IOName() throw() {
}
    
string IOName::getIOName() const throw() {
    return nameIO;
}

string IOName::getUniqueID() const throw() {
    return uniqueID;
}

string IOName::getClassName() const throw() {
    return className;
}

IOName::iterator IOName::begin(){
  expandWildcards();
  return m_list.begin();
}

IOName::iterator IOName::end(){
  expandWildcards();
  return m_list.end();
}

IOName::const_iterator IOName::begin() const {
  const_cast<IOName*> (this) -> expandWildcards();
  return m_list.begin();
}

IOName::const_iterator IOName::end() const {
  const_cast<IOName*> (this) -> expandWildcards();
  return m_list.end();
}

bool IOName::wildcard()const{
  return false;
}

void IOName::expandWildcards() {
}

}
