#ifndef SCT_IOMANAGER_DUMMY_H
#define SCT_IOMANAGER_DUMMY_H

#include "IOManager.h"
#include <string>

namespace Sct {
  /**
   * Dummy IOManager provides streamers for code validation by UnitTest purposes only!
   *
   */
class IOManagerDummy : public IOManager {
public:
    static IOManagerDummy& instance() throw();
    /**
       Do not use!
    */
    virtual void write(const Serializable& ob, const IOParams* params = 0) const;
    /**
     * Do not use!
     */
    virtual shared_ptr<Serializable> read(const string& name, const IOParams* params = 0) const;
    /**
     * Stream to a string
     */
    std::string testStreaming1(const Streamable& s) const;
    /**
     * Stream to a string 
     */
    std::string testStreaming2(const Streamable& s) const;
    
protected:
    IOManagerDummy() throw();
};

}

#endif // SCT_IOMANAGER_DUMMY_H
