#ifndef SCT_ILUMARSHALLING_H
#define SCT_ILUMARSHALLING_H

#include <list>
#include <string>
#include <vector>

namespace Sct {
    
/**
  Contains a set of functions useful for converting between normal objects
  and ILU objects.  
  @author Matthew Palmer based on an original by Bruce Gallop
  */

inline ilu_T_CString copyStringToILU(std::string str) {
    char *copy = (char *)malloc((str.length()+1) * sizeof(char));
    strncpy(copy, str.c_str(), str.length());
    copy[str.length()] = 0;
    return copy;
}

template <typename ILUSequence, typename ListMember>
inline ILUSequence *copyListToILU(std::list<ListMember> thisList) {
  ILUSequence *result;

  result = ILUSequence::Create(4, NULL);
  result->Clear(0);

  for(typename std::list<ListMember>::const_iterator m = thisList.begin();
      m!=thisList.end();
      m++) {
    result->Append(*m);
  }

  return result;
}

template <typename ILUSequence>
inline ILUSequence *copyStringListToILU(std::list<std::string> thisList) {
  ILUSequence *result;

  result = ILUSequence::Create(4, NULL);
  result->Clear(0);

  for(std::list<std::string>::const_iterator m = thisList.begin();
      m!=thisList.end();
      m++) {
    char *copy = (char *)malloc((m->length()+1) * sizeof(char));
    strncpy(copy, m->c_str(), m->length());
    copy[m->length()] = 0;
    result->Append(copy);
  }

  return result;
}

template <typename ILUSequence, typename ListMember>
inline std::list<ListMember> copyILUToList(ILUSequence* thisSeq) {
  std::list<ListMember> result;

  if (thisSeq) {
      for(unsigned int i=0; i<thisSeq->Length(); i++) {
	  result.push_back(thisSeq->Nth(i));
      }
  }

  return result;
}


template <typename ILUSequence, typename List>
inline List copyILUToStdCollection(ILUSequence* thisSeq) {
  List result;

  if (thisSeq) {
      for(unsigned int i=0; i<thisSeq->Length(); i++) {
          result.push_back(thisSeq->Nth(i));
      }
  }

  return result;
}


template <typename ILUSequence, typename ArrayMember>
inline ILUSequence *copyArrayToILU(ArrayMember *array, unsigned long length) {
  ILUSequence *result;

  result = ILUSequence::Create(4, NULL);
  result->Clear(0);

  if(array) {
    for(unsigned long i=0; i<length; i++) {
      result->Append(array[i]);
    }
  }

  return result;
}

template <typename ILUSequence, typename ArrayMember>
inline ILUSequence *copyVectorToILU(std::vector<ArrayMember> array) {
  ILUSequence *result;

  result = ILUSequence::Create(4, NULL);
  result->Clear(0);

  for(unsigned long i=0; i<array.size(); i++) {
    result->Append(array[i]);
  }

  return result;
}

template <typename ILUMatrix, typename ILUSequence, typename ArrayMember>
inline ILUMatrix *copyVectorVectorToILU(std::vector<std::vector<ArrayMember> > matrix) {
  ILUMatrix *result;

  result = ILUMatrix::Create(4, NULL);
  result->Clear(0);

  for(unsigned long i=0; i<matrix.size(); i++) {
    ILUSequence *seq = ILUSequence::Create(4, NULL);
    seq->Clear(0);
    for(unsigned long j=0; j<matrix[i].size(); j++) {
      seq->Append(matrix[i][j]);
    }
    result->Append(seq);
  }

  return result;
}

template <typename ILUBlock, typename ArrayMember>
inline ArrayMember *copyILUToArray(ILUBlock thisSeq, ArrayMember *array, size_t length) {
  assert(thisSeq->Length() == length);
  for(unsigned int i=0; i<length; i++) {
    array[i] = thisSeq->Nth(i);
  }

  return array;
}
  
  
}


#endif //SCT_ILUMARSHALLING_H
