#ifndef SCT_FILE_OSTREAMFILE_H
#define SCT_FILE_OSTREAMFILE_H

#include "../OStream.h"
#include "../IoExceptions.h"

#include <cstdio>
#include <string>
#include <cstring>


#ifdef _GNU_SOURCE
#define FWRITE fwrite_unlocked
#define FLOCKFILE(a) flockfile(a)
#define FUNLOCKFILE(a) funlockfile(a)
#else
#define FWRITE fwrite
#define FLOCKFILE(a)
#define FUNLOCKFILE(a)
#endif


using std::fopen;
using std::fclose;
using std::fwrite;
using std::ftell;
using std::strlen;
using std::string;

namespace Sct {
namespace File {
    
template<typename T>
void write(FILE* f, T t);

template<typename T>
void writeArray(FILE* f, const T* t, size_t size);
    
class OStreamFile : public virtual OStream {
public:
    OStreamFile(const string& fileName) : file(0) {
	file = fopen(fileName.c_str(), "wb");
	if (!file) {
	    throw FileException(fileName, "Couldn't open file", __FILE__, __LINE__);
	}
        setvbuf(file, 0, _IOFBF, BUFSIZ);
	FLOCKFILE(file);
    }
    
    virtual ~OStreamFile() {
	if (file) {
	    FUNLOCKFILE(file);
	    fclose(file);
	}
    }
    
    virtual OStream & operator<<(bool val) {
	write(file, val);
	return *this;
    }
    
    virtual OStream & operator<<(char val) {
	write(file, val);
	return *this;
    }
    
    virtual OStream & operator<<(unsigned char val) {
	write(file, val);
	return *this;
    }
    
    virtual OStream & operator<<(short val) {
	write(file, val);
	return *this;
    }
    
    virtual OStream & operator<<(unsigned short val){
	write(file, val);
	return *this;
    }
    
    virtual OStream & operator<<(int val) {
	write(file, val);
	return *this;
    }
    
    virtual OStream & operator<<(unsigned int val) {
	write(file, val);
	return *this;
    }
    
    virtual OStream & operator<<(long val) {
	write(file, val);
	return *this;
    }
    
    virtual OStream & operator<<(unsigned long val) {
	write(file, val);
	return *this;
    }
    
    virtual OStream & operator<<(double val) {
	write(file, val);
	return *this;
    }
    
    virtual OStream & operator<<(float val) {
	write(file, val);
	return *this;
    }
    
    virtual OStream & operator<<(const std::string & val) {
	*this << val.c_str();
	return *this;
    }
    
//    virtual OStream & operator<<(OWLDate & val)  = 0;
//    virtual OStream & operator<<(OWLTime & val)  = 0;

    virtual OStream & operator<<(const char * str) {
	writeArray(file, str, strlen(str)+1);
	return *this;
    }
    
    virtual OStream & operator<<(const unsigned char * str) {
	writeArray(file, str, strlen((char*)str)+1);
	return *this;
    }
    
    virtual OStream & put(const bool* p, size_t size) {
	writeArray(file, p, size);
	return *this;
    }
    
    virtual OStream & put(const char* p, size_t size) {
	writeArray(file, p, size);
	return *this;
    }
    
    virtual OStream & put(const unsigned char* p, size_t size) {
	writeArray(file, p, size);
	return *this;
    }
  
    virtual OStream & put(const short* p, size_t size) {
	writeArray(file, p, size);
	return *this;
    }
  
    virtual OStream & put(const unsigned short* p, size_t size) {
	writeArray(file, p, size);
	return *this;
    }
  
    virtual OStream & put(const int* p, size_t size) {
	writeArray(file, p, size);
	return *this;
    }
  
    virtual OStream & put(const unsigned int* p, size_t size) {
	writeArray(file, p, size);
	return *this;
    }
  
    virtual OStream & put(const long* p, size_t size) {
	writeArray(file, p, size);
	return *this;
    }
  
    virtual OStream & put(const unsigned long* p, size_t size) {
	writeArray(file, p, size);
	return *this;
    }
  
    virtual OStream & put(const float* p, size_t size) {
	writeArray(file, p, size);
	return *this;
    }
  
    virtual OStream & put(const double* p, size_t size) {
	writeArray(file, p, size);
	return *this;
    }
  
    virtual OStream & put(const std::string* p, size_t size) {
	writeArray(file, p, size);
	return *this;
    }
  
//    virtual OStream & put(const OWLDate* p, size_t size) = 0;
//    virtual OStream & put(const OWLTime* p, size_t size) = 0;
    
private:
    FILE* file;
};

template<typename T>
void write(FILE* f, T t) {
    FWRITE(&t, sizeof(T), 1, f);
}

template<typename T>
void writeArray(FILE* f, const T* t, size_t size) {
    //cout << "WriteArray at: " << ftell(f) << endl;
    write(f, size);
    FWRITE(t, sizeof(T), size, f);
}


}
}

#undef FWRITE
#endif //SCT_FILE_OSTREAMFILE_H
