#ifndef SCT_FILE_ISTREAMFILE_H
#define SCT_FILE_ISTREAMFILE_H

#include "../IStream.h"
#include "../IoExceptions.h"

#include <cstdio>
#include <string>
#include <cstring>
#include <stdio_ext.h>

#ifdef _GNU_SOURCE
#define FREAD fread_unlocked
#define FLOCKFILE(a) flockfile(a)
#define FUNLOCKFILE(a) funlockfile(a)
#else
#define FREAD fread
#define FLOCKFILE(a)
#define FUNLOCKFILE(a)
#endif

using std::fopen;
using std::fclose;
using std::fread;
using std::ftell;
using std::string;
using std::strcpy;
using std::cout;
using std::endl;

namespace Sct {
namespace File {

template<typename T>
void readArray(FILE* file, T* p, size_t size, size_t actualSize);

template<typename T>
void readArrayCreate(FILE* file, T** p, size_t& size);

template<typename T>
void readArrayNoCreate(FILE* file, T* p, size_t size);

template<typename T>
void read(FILE* f, T& p);

class IStreamFile : public virtual IStream {
public:
    IStreamFile(const string& fileName) : file(0) {
	file = fopen(fileName.c_str(), "rb");
        if (!file) {
            throw FileException(fileName, "Couldn't open file", __FILE__, __LINE__);
        }
   
        setvbuf(file, 0, _IOFBF, BUFSIZ);        
	FLOCKFILE(file);
    }

    virtual ~IStreamFile() {
        if (file) {
	    FUNLOCKFILE(file);
            fclose(file);
        }
    }

    virtual IStream & operator>>(char *str) {
	readArrayNoCreate(file, str, ULONG_MAX);
	return *this;
    }

    virtual IStream & operator>>(unsigned char *str) {
        readArrayNoCreate(file, str, ULONG_MAX);
	return *this;
    }

    virtual IStream & operator>>(char **str) {
	size_t size;
	readArrayCreate(file, str, size);
	return *this;
    }

    virtual IStream & operator>>(unsigned char **str)  {
	size_t size;
	readArrayCreate(file, str, size);
	return *this;
    }

    virtual IStream & operator>>(bool& val) {
        read(file, val);
        return *this;
    }

    virtual IStream & operator>>(char& val) {
        read(file, val);
	return *this;
    }

    virtual IStream & operator>>(unsigned char& val) {
        read(file, val);
        return *this;
    }

    virtual IStream & operator>>(short& val) {
        read(file, val);
        return *this;
    }

    virtual IStream & operator>>(unsigned short& val) {
        read(file, val);
        return *this;
    }

    virtual IStream & operator>>(int& val) {
        read(file, val);
        return *this;
    }

    virtual IStream & operator>>(unsigned int& val) {
        read(file, val);
        return *this;
    }

    virtual IStream & operator>>(long& val)  {
        read(file, val);
        return *this;
    }

    virtual IStream & operator>>(unsigned long& val) {
        read(file, val);
        return *this;
    }

    virtual IStream & operator>>(float& val) {
        read(file, val);
        return *this;
    }

    virtual IStream & operator>>(double& val) {
        read(file, val);
        return *this;
    }

    virtual IStream & operator>>(std::string& val) {
	char* buffer;
        *this >> &buffer;
	val = buffer;
        return *this;
    }

    //    virtual IStream & operator>>(OWLDate& val) = 0;
    //    virtual IStream & operator>>(OWLTime& val) = 0;


    virtual IStream & get ( bool ** p, size_t & size ) {
	readArrayCreate(file, p, size);
        return *this;
    }

    virtual IStream & get ( char ** p, size_t & size ) {
	readArrayCreate(file, p, size);
        return *this;
    }

    virtual IStream & get ( unsigned char ** p, size_t & size ) {
	readArrayCreate(file, p, size);
	return *this;
    }

    virtual IStream & get( short ** p, size_t & size ) {
	readArrayCreate(file, p, size);
	return *this;
    }

    virtual IStream & get( unsigned short ** p, size_t & size ) {
	readArrayCreate(file, p, size);
        return *this;
    }

    virtual IStream & get( int ** p, size_t & size ) {
	readArrayCreate(file, p, size);
        return *this;
    }

    virtual IStream & get( unsigned int ** p, size_t & size ) {
	readArrayCreate(file, p, size);
        return *this;
    }

    virtual IStream & get( long ** p, size_t & size ) {
	readArrayCreate(file, p, size);
        return *this;
    }

    virtual IStream & get( unsigned long ** p, size_t & size ) {
	readArrayCreate(file, p, size);
        return *this;
    }

    virtual IStream & get( float ** p, size_t & size ) {
	readArrayCreate(file, p, size);
        return *this;
    }

    virtual IStream & get( double ** p, size_t & size ) {
	readArrayCreate(file, p, size);
        return *this;
    }

    virtual IStream & get( std::string ** p, size_t & size ) {
	readArrayCreate(file, p, size);
        return *this;
    }

    //    virtual IStream & get( OWLDate ** p, size_t & size ) = 0;
    //    virtual IStream & get( OWLTime ** p, size_t & size ) = 0;

    virtual IStream & get( bool * const p, const size_t size ) {
        readArrayNoCreate(file, p, size);
        return *this;
    }

    virtual IStream & get( char * const p, const size_t size ) {
        readArrayNoCreate(file, p, size);
	return *this;
    }

    virtual IStream & get( unsigned char * const p, const size_t size ) {
        readArrayNoCreate(file, p, size);
	return *this;
    }

    virtual IStream & get( short * const p, const size_t size ) {
        readArrayNoCreate(file, p, size);
	return *this;
    }

    virtual IStream & get( unsigned short * const p, const size_t size ) {
        readArrayNoCreate(file, p, size);
	return *this;
    }

    virtual IStream & get( int * const p, const size_t size ) {
        readArrayNoCreate(file, p, size);
	return *this;
    }

    virtual IStream & get( unsigned int * const p, const size_t size ) {
        readArrayNoCreate(file, p, size);
	return *this;
    }

    virtual IStream & get( long * const p, const size_t size ) {
        readArrayNoCreate(file, p, size);
	return *this;
    }

    virtual IStream & get( unsigned long * const p, const size_t size ) {
        readArrayNoCreate(file, p, size);
        return *this;
    }

    virtual IStream & get( float * const p, const size_t size ) {
        readArrayNoCreate(file, p, size);
        return *this;
    }

    virtual IStream & get( double * const p, const size_t size ) {
        readArrayNoCreate(file, p, size);
        return *this;
    }

    virtual IStream & get( std::string * const p, const size_t size ) {
        readArrayNoCreate(file, p, size);
        return *this;
    }

    //    virtual IStream & get( OWLDate * const p, const size_t size ) = 0;
    //    virtual IStream & get( OWLTime * const p, const size_t size ) = 0;

private:
    FILE* file;
};

template<typename T>
void readArray(FILE* file, T* p, size_t size, size_t actualSize) {
    if (size >= actualSize) {
	FREAD(p, sizeof(T), actualSize, file);
	return;
    } else {
	cout << "Reading less than stored array size - buffer size: " << size << " actual size: " << actualSize << "  at: " << ftell(file) << endl;
	FREAD(p, sizeof(T), size, file);
	T temp[actualSize-size];
	FREAD(&temp, sizeof(T), actualSize-size, file);
    }
}

template<typename T>
void readArrayCreate(FILE* file, T** p, size_t& size) {
    //cout << "readArrayCreate at: " << ftell(file) << endl;
    read(file, size);
    //cout << "Create array: " << size << endl;
    *p = new T[size];
    readArray(file, *p, size, size);
}

template<typename T>
void readArrayNoCreate(FILE* file, T* p, size_t size) {
    //cout << "readArrayNoCreate at: " << ftell(file) << endl;
    size_t actualSize = 0;
    read(file, actualSize);
    //cout << "Read array: " << actualSize <<  "buffer size: " << size << endl;
    readArray(file, p, size, actualSize);
}

template<typename T>
void read(FILE* f, T& p) {
    FREAD(&p, sizeof(T), 1, f);
}

}
}

#undef FREAD

#endif //SCT_FILE_ISTREAMFILE_H
