#include "IONameFile.h"
#include "../SctNames.h"

namespace Sct {
namespace File {

IONameFile::IONameFile(const string& fileName) throw(InvalidArgument) : IOName(fileName) {
    IONameFile::parse();
}

IONameFile::IONameFile(const string& uniqueID, const string& className) throw() : IOName(uniqueID, className) {
    IONameFile::construct();
}

IONameFile::~IONameFile() throw() {
}

IONameFile::IONameFile() {
}


void IONameFile::parse() throw(InvalidArgument) {
    int dot = nameIO.rfind('/');		//We want last /
    int dot2 = nameIO.find('.', ++dot);
    className = nameIO.substr(dot, dot2-dot);  //ClassName is everything between the last / and second .
    uniqueID = nameIO.substr(++dot2);
}

void IONameFile::construct() throw() {
    nameIO = SctNames::getTempDir();
    nameIO += "/" + className;
    nameIO += "." + uniqueID;
}

}
}

