#ifndef SCT_FILE_IOMANAGERFILE_H
#define SCT_FILE_IOMANAGERFILE_H

#include "../IOManager.h"
#include "../IoExceptions.h"
#include "../LogicErrors.h"

namespace Sct {
namespace File {
	
class IOManagerFile : public IOManager {
public:
    static IOManagerFile& instance();
    
    virtual void write(const Serializable& ob, const IOParams* params = 0) const throw(LogicError, IoError);
    virtual shared_ptr<Serializable> read(const string& name, const IOParams* params = 0) const throw(LogicError, IoError);
    
private:
    IOManagerFile() throw();
};
}
}
#endif //SCT_FILE_IOMANAGERFILE_H
