#include "IOManagerFile.h"
#include "IStreamFile.h"
#include "OStreamFile.h"
#include "IONameFile.h"
#include "../Serializable.h"

namespace Sct {
namespace File {
    
IOManagerFile::IOManagerFile() throw() {
}

IOManagerFile& IOManagerFile::instance() {
    static IOManagerFile man;
    return man;
}
    
void IOManagerFile::write(const Serializable& ob, const IOParams* params) const throw(LogicError, IoError) {
    IONameFile name(ob.getUniqueID(), ob.getClassName());
    OStreamFile out(name.getIOName());
    writeImpl(out, ob, true);
}

shared_ptr<Serializable> IOManagerFile::read(const string& name, const IOParams* params) const throw(LogicError, IoError) {
    IStreamFile in(name);
    return boost::dynamic_pointer_cast<Serializable>(readImpl(in));
}
    

    
}
}
