#ifndef SCT_CONFIGURATIONEXCEPTION_H
#define SCT_CONFIGURATIONEXCEPTION_H
#include "Exception.h"

namespace Sct {

/**
 * Thrown when an error in the configuration is found. e.g.
 * where a particular process cannot sensibly start.
 * @ingroup Exceptions
 * @author Alan Barr
 */
class ConfigurationException : public Exception {
public:
    /**
      Creates an Exception with message msg and no cause
      */
    ConfigurationException(const string& msg, const string& file, int line) throw() {
	initialize("BAD_CONFIG", "Sct::ConfigurationException", msg, 0, file, line);
    }
    
    /**
      Creates an Exception with a cause.  Useful for simply wrapping
      exceptions.
      */
    ConfigurationException(Throwable& cause, const string& file, int line) throw() {
	initialize("BAD_CONFIG", "Sct::ConfigurationException", "", &cause, file, line);
    }
    
    /**
      Creates an Exception with a message and a cause
      */
    ConfigurationException(const string& msg, Throwable& cause, const string& file, int line) throw() {
	initialize("BAD_CONFIG", "Sct::ConfigurationException", msg, &cause, file, line);
    }
    
protected:
    ConfigurationException() throw() {} 
};

}

#endif //SCT_CONFIGURATIONEXCEPTION_H
