#include "IONameArchiveFile.h"
#include "../SctNames.h"

#include <fstream>

namespace Sct {
namespace Archive {

IONameArchiveFile::IONameArchiveFile(const string& fileName) throw(InvalidArgument) : IOName(fileName) {
    IONameArchiveFile::parse();
}

IONameArchiveFile::IONameArchiveFile(const string& uniqueID, const string& className) throw() : IOName(uniqueID, className) {
    IONameArchiveFile::construct();
}

IONameArchiveFile::~IONameArchiveFile() throw() {
}

IONameArchiveFile::IONameArchiveFile() {
}

bool IONameArchiveFile::wildcard()const{
  if (nameIO.find("*")!=string::npos){
    std::cout << nameIO << " has a wildcard " << std::endl;
  }
  std::cout << std::endl;
  return (nameIO.find("*")!=string::npos);
}

void IONameArchiveFile::expandWildcards(){
  if (m_wildcardsExpanded || !wildcard() ) return;
  m_wildcardsExpanded=true;
  std::ostringstream oss;  oss << SctNames::getTempDir() << "/ArchivingList.XXXXXX";
  char tempfile_template[oss.str().size()];
  char* tempfile= tempfile_template;
  strcpy(tempfile, oss.str().c_str());
  mkstemp(tempfile);
  string fullcmd="ls "; fullcmd += nameIO;
  fullcmd += " > "; fullcmd += tempfile;
  if (system (fullcmd.c_str() ) !=0 ) {
    throw Sct::IoError(string("Error executing command :") + fullcmd, __FILE__, __LINE__);
  }
  std::ifstream f(tempfile);
  while (f.good()){
    string name; f>> name; if(!f.good()) break;
    shared_ptr<IONameArchiveFile> item (new IONameArchiveFile(name) );
    std::cout << "adding " << name << std::endl;
    m_list.push_back(item);
  }
}

void IONameArchiveFile::parse() throw(InvalidArgument) {
    int ldot = nameIO.rfind(".gz");
    int slash = nameIO.rfind('/');		//We want last /
    int dot2 = nameIO.find('.', ++slash);

    if (ldot==string::npos || slash==string::npos || dot2==string::npos){
      throw InvalidArgument(string("Error parsing IONameArchiveFile ") + nameIO,
			    __FILE__, __LINE__);
    }
    className = nameIO.substr(slash, dot2-slash);
    uniqueID = nameIO.substr(dot2+1, ldot-dot2-1);
}

void IONameArchiveFile::construct() throw() {
    nameIO = SctNames::getPersistentDir();
    nameIO += "/" + className;
    nameIO += "." + uniqueID;
    nameIO += ".gz";
}

}
}
