#include "IOManagerArchiveFile.h"
#include "gzstream.h"
#include "IONameArchiveFile.h"
#include "IOParamsArchive.h"

#include "../Streamer.h"
#include "../Serializable.h"
#include "../SctNames.h"
#include "../XmlStyleStream.h"
#include "../StdExceptionWrapper.h"

#include <cstdlib>

using std::string;

namespace Sct {
  namespace Archive {
    
    IOManagerArchiveFile::IOManagerArchiveFile() throw() {
    }
    
    IOManagerArchiveFile* IOManagerArchiveFile::s_man=0;
    
    IOManagerArchiveFile& IOManagerArchiveFile::instance() {
      if (!s_man) s_man=new IOManagerArchiveFile();
      return *s_man;
    }
    
    std::string IOManagerArchiveFile::status() const{
      std::ostringstream oss;
      oss << "IOManagerArchiveFile. Using Directory : " 
	  << SctNames::getPersistentDir() << std::endl;
      return oss.str();
    }

    void IOManagerArchiveFile::write(const Serializable& ob, const IOParams* par) const {
      const IOParamsArchive* params = par ? dynamic_cast<const IOParamsArchive*>(par) : 0;
      boost::recursive_mutex::scoped_lock lock (getMutex());
      setReadMode(false);
      IONameArchiveFile name(ob.getUniqueID(), ob.getClassName());
      const std::string& file=name.getIOName();
      
      // ogzstream dosen't test if file is writable, so we must check ourselves
      if ( 
	  system( (string("test -w `dirname ")+file+"`").c_str() ) 
	  ) throw FileException(file,"Directory not writable",__FILE__,__LINE__);
      
      bool file_exists = !system( (string("test -f ")+file).c_str() );
      if ( file_exists ) {
	if (params && params->getOverWrite() ) {
	  system( (string("chmod +w ")+file).c_str() );
	} else {
	  throw FileException(file,"File already exists",__FILE__,__LINE__);
	}
      }
      ogzstream oz(name.getIOName().c_str(),std::ios::out, getCompressionLevel());
      if (!oz.good()) throw FileException(name.getIOName(),"Error opening file to write.",__FILE__,__LINE__);
      
      XmlStyleOStream out_ad(oz);
      
      out_ad << "SctRodDaq";
      writeImpl(out_ad, ob, false);
      
      if (system( (string("chmod -w ")+file ).c_str() )) throw FileException(name.getIOName(),"Error making file read-only.",__FILE__,__LINE__);
    }
  
    boost::shared_ptr<Serializable> IOManagerArchiveFile::read(const string& name, const IOParams* params) const {
      setReadMode(true);
      getReadVersionMap().clear();
      IONameArchiveFile ioname(name);
      
      if ( system( (string("test -r ")+name).c_str() ) ) throw FileException(name,"Not readable",__FILE__,__LINE__);
      
      igzstream iz(ioname.getIOName().c_str());
      if (!iz.good()) throw FileException(ioname.getIOName(),"Error opening file to read.",__FILE__,__LINE__);
      
      XmlStyleIStream in_ad(iz);
      string tmp;
      in_ad >> tmp;
      
      if (tmp.find("SctRodDaq")==string::npos) {
	std::ostringstream oss;
	oss << name << " does not look like a SctRodDaq archive file ... starts with " << tmp;
	throw StreamCorruptedException(oss.str(), __FILE__, __LINE__);
      }
      
      return boost::dynamic_pointer_cast<Serializable>(readImpl(in_ad));
    }
  }
}
