#ifndef SCT_ARCHIVEFILE_IOMANAGERARCHIVE_H
#define SCT_ARCHIVEFILE_IOMANAGERARCHIVE_H
#include "IOManagerStreamerVersioned.h"
#include <string>

namespace Sct {
namespace Archive{
/** Class for zipped archiving */
class IOManagerArchive : public IOManagerStreamerVersioned {
public:
    /** constructor sets default compression level */
    IOManagerArchive() throw();
    virtual ~IOManagerArchive();
    /** set the gzip compression level in the range 0->9 */
  void setCompressionLevel(int level);
  /** get the gzip compression level */
  int getCompressionLevel() const;
  /** return status string */
  virtual std::string status() const =0;
 protected:
  int m_compression_level;  ///< gzip compression level 1->9 
  static int s_default_compression_level; ///< default gzip level 1->9;
};
}
}
#endif //SCT_ARCHIVEFILE_IOMANAGERARCHIVE_H
