#include "IOManagerArchive.h"

namespace Sct {
  namespace Archive {
    
    int IOManagerArchive::s_default_compression_level=3;

    IOManagerArchive::IOManagerArchive() throw() {
      setCompressionLevel(s_default_compression_level);
    }

    IOManagerArchive::~IOManagerArchive() {}
    
    void IOManagerArchive::setCompressionLevel(int level){
      boost::recursive_mutex::scoped_lock lock (getMutex());
      if (level<1) { m_compression_level=1 ; } 
      else if (level>9) { m_compression_level=9; } 
      else { m_compression_level=level; }
    }

    int IOManagerArchive::getCompressionLevel() const {
      return m_compression_level;
    }
  }
}
