$outputFile = $ARGV[0];
@inputFiles = @ARGV[1..$#ARGV];

print "output $outputFile\n";
print "input @inputFiles\n";

if($outputFile =~ m!([\w/]*)/([\w]*).java!) {
    $packageName = $1;
    $packageName =~ s/\//\./g;
    $className = $2;

    print "Generating package $packageName, class $className from $outputFile\n";
} else {
    die "*** $outputFile is not a valid java file name";
}
open(JAVAOUT, ">$outputFile")   or die "Can't open $outputFile: $!";

print JAVAOUT <<ENDHEADER;
// This is an automatically generated helper class
//  See genScanDescriptors.pl
package $packageName;

class $className {
    static class Descriptor {
      int value; String name;
      Descriptor(int v, String n) { value = v; name = n; }
    }

    static Descriptor [] descs; // = new Descriptor[numVars];

    static Descriptor [] getDescriptors() {
        if(descs == null) {
            descs = new Descriptor[numVars];
ENDHEADER

$count = 0;
foreach $infile (@inputFiles) {
    open(INFILE, $infile)   or die "Can't open ($infile): $!";

    while(<INFILE>) {
        if(/define *(ST_[A-Z_0-9]*) *([0-9]*)/) { 
            print JAVAOUT "            descs[$count] = new Descriptor($2, \"$1\");\n";
            $count ++;
        }
        if(/define *(SCT_SCAN_[A-Z_0-9]*) *([0-9]*)/) { 
            print JAVAOUT "            descs[$count] = new Descriptor($2, \"$1\");\n";
            $count ++;
        }
        if(/define *(MVAR_[A-Z_0-9]*) *([0-9]*)/) { 
            print JAVAOUT "            descs[$count] = new Descriptor($2, \"$1\");\n";
            $count ++;
        }
    }
}

print JAVAOUT <<ENDTRAILER;
        }
        return descs;
    }
    static final int numVars = $count;
}
ENDTRAILER
