package Sct.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Box;


/**
   A dialog for entering multiple items
 */
public class SelectionDialog extends JDialog {
    JTextField textFields[];
    String fields[];
    String defaults[];

    boolean valid;

    /**
       @param owner Parent frame
       @param title Title of dialog box
       @param fs Field names
       @param ds Default text to put in textFields
     */
    public SelectionDialog(java.awt.Frame owner, String title, String fs[], String ds[]) {
        super(owner, title, true);

        fields = fs;
        defaults = ds;

        valid = true;

        buildGUI();
    }

    /**
       Build the GUI panel
     */
    private void buildGUI() {
        getContentPane().removeAll();

        Box allBox = Box.createVerticalBox();
        Box box = Box.createVerticalBox();

        textFields = new JTextField[fields.length];

        for(int f=0; f<fields.length; f++) {
            JPanel panel = new JPanel();
            panel.add(new JLabel(fields[f] + ":"));
            textFields[f] = new JTextField(defaults[f], 5);
            panel.add(textFields[f]);
             box.add(panel);
        }

        allBox.add(box);

        JPanel buttonPanel = new JPanel();

        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    valid = false;
                    dispose();
                }
            });
        buttonPanel.add(cancel);

        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    dispose();
                }
            });
        buttonPanel.add(okButton);

        allBox.add(buttonPanel);
        getContentPane().add(allBox);
    }

    /**
       Try and interpret field index as an integer and return that value
       @param index Index into fields array
     */
    public int getIntFieldValue(int index) throws InvalidDialogException, CancelledDialogException {
        if(!valid) throw new CancelledDialogException();
        try {
            return Integer.decode(textFields[index].getText()).intValue();
        } catch(NumberFormatException n) {
            System.out.println("NumberFormatException: " + n);
            throw new InvalidDialogException();
        }
    }

    /**
       Try to interpret field index as a String and return that value
       @param index Index into fields array
     */
    public String getStringFieldValue(int index) throws InvalidDialogException, CancelledDialogException {
        if(!valid) throw new CancelledDialogException();
        return textFields[index].getText();
    }

    /**
       Thrown if can't parse int field
     */
    public static class InvalidDialogException extends Exception {
    }

    /**
       Thrown if accessed without clicking OK
     */
    public static class CancelledDialogException extends Exception {
    }
}
