/*
 * GenericFunction.java
 *
 * Created on 19 December 2002, 14:47
 */

package Sct.function;

import hep.aida.*;

/**
 *
 * @author  palmer
 */
public abstract class GenericFunction implements IFunction {
    protected int dim;
    protected String title;
    protected double[] params;
    protected String[] paramNames;
    protected String[] varNames;
    
    /** Creates a new instance of GenericFunction */
    public GenericFunction(int dimension, int params) {
        dim = dimension;
        varNames = new String[dimension];
        this.params = new double[params];
        paramNames = new String[params];
        title = getName();
    }
    
    public hep.aida.IAnnotation annotation() {
        return null;
    }
    
    public String codeletString() {        
        return "codelet:" + this.getClass().getName() + ":file:";
    }
    
    public int dimension() {
        return dim;
    }
    
    public double[] gradient(double[] values) {
        return null;
    }
    
    public int indexOfParameter(String str) {
        for (int i=0; i<params.length; i++) {
            if (paramNames[i].equals(str)) return i;
        }
        return -1;  //Will cause an exception if used to address anywhere
    }
    
    public boolean isEqual(hep.aida.IFunction iFunction) {
        return this==iFunction;
    }
    
    public int numberOfParameters() {
        return params.length;
    }
    
    public double parameter(String str) {
        return params[indexOfParameter(str)];
    }
    
    public String[] parameterNames() {
        return paramNames;
    }
    
    public double[] parameters() {
        return params;
    }
    
    public boolean providesGradient() {
        return false;
    }
    
    public void setParameter(String str, double param) throws java.lang.IllegalArgumentException {
        params[indexOfParameter(str)] = param;
    }
    
    public void setParameters(double[] values) {
        if (values.length == params.length) params = values;
    }
        
    public String variableName(int param) {
        return varNames[param];
    }
    
    public String[] variableNames() {
        return varNames;
    }

    public String title() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    
    public abstract String getName();    
}
