package Sct.function;

import com.imsl.math.Sfun;

public class ErfFunction extends GenericFunction {
    
    public ErfFunction() {
        super(1, 3);
    }
    
    public double value(double[] vars) {
        double xx, y;

        // if width==0, return zero:
        if(params[2] == 0){
            xx = 0.;
        }else{
            xx = ( (params[1]-vars[0]) / params[2]) / 1.414213562;
        }

        y  = (params[0]/2.) * ( 1 - Sfun.erf(xx) );

        return y;     
    }
    
    public String getName() {
        return "erf";
    }
    
}
