package Sct;

/**
 * This interface represents a data class that can be streamed.
 *
 * The class with the name returned by getClassName must define a static method with the following name and signature:
 * @code public static Streamable read(IStream s, ObjectManager o) throws java.io.IOException
 *
 * It is possible for this method to act as a named constructor but may also be more complex.
 * For example it could be useful if you want to be able to read in a reference to a singleton or to a hierarchy 
 * where for some reason the className isn't stored (compatability perhaps) and so some other way
 * of determining the correct class is used.   
 *
 * @author Matthew Palmer
 */
public interface Streamable {

    /**
     * Return the class name of the class that is capable of dealing with reading.
     * Often the same name as the most derived class, but not necessarily e.g. Singletons
     * may delegate de-serialization to another class that implements the static method mentioned above.
     */
    public String getClassName();
    
    /**
     * Read this object from an IStream and an ObjectManager
     * @code
     * public static Streamable read(IStream s, ObjectManager o) throws java.io.IOException;
     */    
    
    /**
     * Write this to an OStream using an ObjectManager.
     */
    public void write(OStream s, ObjectManager o) throws java.io.IOException;
}