/*
 * SerializableWrapper.java
 *
 * Created on 07 November 2003, 11:17
 */

package Sct;

/**
 * Wraps a Streamable and makes it Serializable
 * Has a number of options for controlling it.
 * @author  Matthew Palmer
 */
public class SerializableWrapper implements Serializable {

    /**
     * Constructs a SerializableWrapper from a Streamable.  
     * It creates an internal unique ID and uses the name of this
     * class as its class name.
     */
    public SerializableWrapper(Streamable s) {
        this.st = s;
        className = "Sct.SerializableWrapper";
        uniqueID = className + count++;        
    }
    
    /**
     * Creates a SerializableWrapper with
     */
    public SerializableWrapper(Streamable s, String uniqueID, String className) {
        this.st = s;
        this.uniqueID = uniqueID;
        this.className = className;
    }

    public String getClassName() {
        return className;
    }

    public String getUniqueID() {
        return uniqueID;
    }

    public void write(OStream s, ObjectManager o) throws java.io.IOException {
        o.writeObject(s, "Wrapped", this.st, true);
    }
    
    public static SerializableWrapper read(IStream in, ObjectManager o) throws java.io.IOException {            
        return new SerializableWrapper(o.readObject(in, "Wrapped"));
    }

    public Streamable get(){
        return st;
    }

    Streamable st;    
    private static int count = 0;
    private String className;
    private String uniqueID;
};    

