package Sct;

/**
 * This interface extends Streamable by adding the concept of a 
 * unique identifier.  This identifier allows each Serializable to be
 * identified and so a Serializable is the smallest entity that can be stored.  
 * This is not true of a Streamable (unless the system were to generate a random 
 * identifier which it doesn't!).
 *
 * @author Matthew Palmer
 */
public interface Serializable extends Streamable {
    /**
     * @return a String which uniquely identifies this object.
     */
    public String getUniqueID();
}