package Sct;
import java.io.IOException;

///@todo Add read/write for arrays of objects?
public interface ObjectManager {  
    ///{ @name Methods for end-users.
    
    /**
     * Write a Serializable object.
     * @todo Should this take an extra back-end dependant parameter?
     * @return a Name object that can be used to read the written object
     * @throws IOException if a problem occurs during IO
     */ 
    public Name writeObject(Serializable object) throws IOException;
    
    /**
     * Read a Serializable with uniqueID and className as given.     
     * @throws IOException if a problem occurs during IO
     */
    public Serializable readObject(String uniqueID, String className) throws IOException;
    
    
    /**
     * Read a Serializable using the back-end specific identifier.
     * @throws IOException if a problem occurs during IO
     */
    public Serializable readObject(String name) throws IOException;
    
    ///}
    
    ///{ @name Methods for streamer implementors
    
    /**
     * Write an object to the OStream.  Class object's write method. 
     * object may not be null.  Causes a WriteAbortedException if it is.
     * @param s the OStream being used (note, not guranteed to be passed to object's write method)
     * @param name the name of the object in the current context.
     * @param writeClassName if true the className will be written.
     * @throws IllegalArgumentException if object is null
     * @throws IOException if a problem occurs during IO
     */
    public void writeObject(OStream s, String name, Streamable object, boolean writeClassName) throws IOException;
    
    /**
     * Read an object from an IStream.  This method should be used if the object was written with writeClassName = false.
     * Creates the object from the IStream
     * @see Streamable documentation
     * @param s the IStream being read from in the current context.
     * @param name the name of the object in the current context.  Should match the name passed to writeObject.
     * @param className the name of a class capable of streaming in the object.
     * @throws IOException if a problem occurs during IO
     */
    public Streamable readObject(IStream s, String name, String className) throws IOException;
    
     /**
     * Read an object from an IStream.  This method should be used if the object was written with writeClassName = true.
     * First reads the className from the stream.
     * Creates the object from the IStream
     * @see Streamable documentation
     * @param s the IStream being read from in the current context.
     * @param name the name of the object in the current context.  Should match the name passed to writeObject.     
     * @throws IOException if a problem occurs during IO
     */
    public Streamable readObject(IStream s, String name) throws IOException;
    
    ///}
}