package Sct;

/**
 * Abstract class representing a the name of a persistent representation
 * Implementations will derive a class from this.
 * Each implementation of Name provides a string representation - for instance a filename
 * which is contructed from information about the object to be persisted and some implementation
 * defined way of getting e.g. the path.
 *
 * For compatability with C++, the package separator is usually "::" rather than ".".  This
 * class also provides static methods to convert which implementations should use to make this
 * transparent to the user.
 * @author Matthew Palmer
 */
public abstract class Name {    
    
    /**
     * Returns a className suitable for writing from a Java name
     */
    public static String convertToC(String className) {
        return className.replaceAll("\\.", "::");
    }
    
    /**
     * Returns a Java className from a C++ style one read in
     */
    public static String convertFromC(String className) {
        return className.replaceAll("::", ".");
    }
    
    /**
     * Gets the class name of the object this Name represents
     * @return the Class name of the Serializable object
     */ 
    public String getClassName() {
        return className;
    }
    
    /**
     * Gets the uniqueID of the object this Name represents
     * @return the uniqueID
     */
    public String getUniqueID() {
        return uniqueID;
    }
    
    /**
     * Gets the implementation dependant String representation of the name.
     * This can be passed to the appropriate ObjectManager for later retrieval
     * @return the String representation of the Name
     */
    public abstract String getName();
        
    /**
     * Construct a Name for a given Serializable
     * Initializes the uniqueID and ClassNames
     */
    protected Name(Serializable s) {        
        this(s.getClassName(), s.getUniqueID());        
    }
    
    /**
     * Constructs a Name from the implementation dependant representation
     * Calls parse
     */
    protected Name(String name) throws IllegalArgumentException {
        parse(name);
    }
    
    /**
     * Utility - equivalent to Name(Serializable s) given
     * Name(s.getClassName(), s.getUniqueID());
     */
    protected Name(String className, String uniqueID) {
        this.uniqueID = uniqueID;
        this.className = className;
    }    
    
    
    /**
     * Should set the className and uniqueID members by parsing the 
     * implementation dependant representation
     * @param name The implementation dependant representation of the Name
     */
    protected abstract void parse(String name) throws IllegalArgumentException;
    
    protected String uniqueID;      ///< The UniqueID
    protected String className;     ///< The className stored in Java format
}