/*
 * ObjectManagerISProxy.java
 *
 * Created on 30 October 2003, 06:56
 */

package Sct.ISProxy;

import Sct.*;
import Sct.File.ObjectManagerFile;
import Sct.IS.ObjectManagerIS;

/**
 * Handles reading and writing of objects using a proxy.
 * This means that the object is written to a file using Sct.File.ObjectManagerFile
 * but an ISProxy object that points to it is written to IS using
 * Sct.IS.ObjectManagerIS.
 *
 * The basic semantics are:
 * If asked to write a top-level object,, write it to a File, and write a proxy to IS
 * 
 * @author  Matthew Palmer
 */
public class ObjectManagerISProxy extends Sct.IS.ObjectManagerIS {
    
    public static ObjectManagerISProxy instance() {
        if (instance == null) 
            instance = new ObjectManagerISProxy();
        return instance;
    }      
    
    public Name writeObject(Serializable object) throws java.io.IOException {
        ISProxy proxy = new ISProxy(object);
        ObjectManagerFile.getInstance().writeObject(object);
        return super.writeObject(proxy);
    }
    
    public void writeObject(OStream s, String name, Streamable object, boolean writeClassName) throws java.io.IOException{
        if (object instanceof ISProxy) {
            if (writeClassName) writeClassName(s, "Sct.ISProxy.ISProxy");
            object.write(s, this);
        } else 
            super.writeObject(s, name, object, writeClassName);
    }
        
    /** Creates a new instance of ObjectManagerISProxy */
    private ObjectManagerISProxy() {
    }
    
    private static ObjectManagerISProxy instance;
}
